# Scan Opportunities

Scan for LP opportunities, arbitrage, and high-yield pools across all Uniswap deployments.

→ **[SKILL.md](SKILL.md)** — Full skill specification and workflow.

## Installation

Install into Claude Code or Cursor with:

```bash
npx skills add https://github.com/wpank/Agentic-Uniswap/tree/main/.ai/skills/scan-opportunities
```

Or via Clawhub:

```bash
npx clawhub@latest install scan-opportunities
```

## When to use

Use this skill when:

- You want to **scan across chains** for LP and trading opportunities.
- You're looking for **high-fee, high-volume pools** or simple arbitrage leads.
- You want a **shortlist of interesting pools** to investigate further with other skills.

## Example prompts

- "Scan all Uniswap deployments for high-yield USDC pairs with reasonable TVL."
- "Find potential arbitrage opportunities for WETH across Ethereum, Arbitrum, and Base."
- "List the top LP opportunities for stablecoin pairs given moderate risk tolerance."
