#!/usr/bin/env python3
"""
CLI tool to get OAuth token for a service
Usage: python3 get_token.py <service_name>
"""

import sys
from pathlib import Path

# Add skill directory to path
sys.path.insert(0, str(Path(__file__).parent))

from scalekit_helper import get_token, ConfigurationError, AuthorizationError

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Usage: python3 get_token.py <service_name>", file=sys.stderr)
        print("Example: python3 get_token.py gmail", file=sys.stderr)
        sys.exit(1)
    
    service_name = sys.argv[1]
    
    try:
        token = get_token(service_name)
        print(token)
    except (ConfigurationError, AuthorizationError) as e:
        print(str(e), file=sys.stderr)
        sys.exit(1)
    except Exception as e:
        print(f"Unexpected error: {str(e)}", file=sys.stderr)
        sys.exit(1)
