# Scalekit Auth - Secure OAuth Token Management

[![ClawHub](https://img.shields.io/badge/ClawHub-scalekit--auth-blue)](https://clawhub.com)
[![Python](https://img.shields.io/badge/python-3.8+-blue.svg)](https://www.python.org/downloads/)

Centralized OAuth token management for AI agents via [Scalekit](https://scalekit.com). Never store tokens locally again.

## Features

- ✅ **Secure token storage** - No local token files
- ✅ **Automatic refresh** - Always get fresh, valid tokens
- ✅ **Multi-service support** - Gmail, Slack, GitHub, 50+ more
- ✅ **Simple API** - One function call: `get_token(service)`
- ✅ **Public skill** - Easy to share and reuse

## Quick Start

```bash
# Install
clawhub install scalekit-auth
cd skills/scalekit-auth
pip3 install -r requirements.txt

# Configure credentials in .env
echo "SCALEKIT_CLIENT_ID=your_id" > .env
echo "SCALEKIT_CLIENT_SECRET=your_secret" >> .env
echo "SCALEKIT_ENV_URL=https://your-env.scalekit.com" >> .env

# Set up a service (e.g., Gmail)
python3 -c "from scalekit_helper import configure_connection; configure_connection('gmail', 'gmail_u3134a')"

# Get token
python3 get_token.py gmail
```

## Usage in Your Skill

```python
#!/usr/bin/env python3
import sys
sys.path.append('./skills/scalekit-auth')
from scalekit_helper import get_token

# Get fresh token
token = get_token("gmail")

# Use immediately
import requests
headers = {"Authorization": f"Bearer {token}"}
response = requests.get("https://gmail.googleapis.com/gmail/v1/users/me/messages", headers=headers)
```

## Documentation

See [SKILL.md](SKILL.md) for complete documentation.

## Setup Workflow

1. **Install skill** via ClawHub
2. **Get Scalekit credentials** from [app.scalekit.com](https://app.scalekit.com)
3. **Create connections** in Scalekit dashboard for each service
4. **Configure** via agent or CLI
5. **Authorize** when prompted (1-min expiry!)
6. **Use tokens** seamlessly

## License

MIT

## Links

- [Scalekit Docs](https://docs.scalekit.com/agent-auth/quickstart/)
- [ClawHub](https://clawhub.com)
- [OpenClaw](https://openclaw.ai)
