# Execution Cadence

Use this cadence to keep scaling work controlled, measurable, and compounding.

## Weekly Rhythm

- Reconfirm primary bottleneck and objective.
- Review top experiments: continue, pause, rollback, or expand.
- Check guardrail metrics before approving any scale step.
- Re-rank leverage backlog by current evidence.

## Monthly Rhythm

- Validate whether the bottleneck shifted to a new constraint.
- Retire interventions that no longer provide leverage.
- Promote proven temporary boosts into durable process or automation.
- Update ownership where decision latency is rising.

## Scorecard Template

Track one primary objective with three guardrails:
- Primary: throughput or growth objective
- Guardrail 1: reliability or quality
- Guardrail 2: cost or margin
- Guardrail 3: team load or cycle time

## Stop Rules

Pause expansion when any stop rule is hit:
- Guardrail breaches threshold for two consecutive periods
- Incident severity crosses agreed limit
- Rollout assumptions disproven without mitigation plan

## Review Questions

- What bottleneck did we remove this cycle?
- What new bottleneck emerged?
- Which intervention gave durable capacity, not temporary relief?
- What must be simplified before the next growth step?
