# Company Scale Framework

Apply this when a company must scale execution, revenue, or customer operations without losing quality.

## Sequence

### 1. Align Demand and Delivery Capacity
- Forecast demand realistically
- Map current delivery capacity by function
- Identify where backlog growth will break commitments first

### 2. Clarify Ownership and Decision Rights
- Assign one owner per critical metric
- Define which decisions are local vs executive
- Remove approval chains that do not reduce risk

### 3. Standardize Core Operating Loops
- Weekly operating review with the same metrics and owners
- Incident and postmortem loop for major failures
- Hiring and onboarding loop tied to bottleneck functions

### 4. Build Durable Capability Before Headcount Spikes
- Document repeatable workflows first
- Automate high-frequency manual work
- Hire into clear operating systems, not ambiguity

### 5. Scale Go-To-Market with Guardrails
- Keep customer acquisition paired with retention and margin
- Set support capacity thresholds before campaign expansion
- Slow growth pushes that exceed service quality limits

## Red Flags

- Revenue growth without service and support readiness.
- Leadership adding layers faster than decision quality improves.
- KPIs optimized in silos with no company-level tradeoff review.
