---
name: save-to-obsidian
description: Saves markdown content to remote Obsidian vault via SSH
version: 1.0.0
---

# Save to Obsidian

Saves markdown content to remote Obsidian vault via SSH.

## Prerequisite

**This skill is for machines WITHOUT iCloud sync** (e.g., Linux/Ubuntu servers). If your machine already has iCloud Desktop sync enabled and direct access to the Obsidian vault, you don't need this skill — just copy files directly to the vault path.

## When to Use

User says: "save to obsidian", "send to obsidian", "copy to obsidian"

## Process

1. Write content to a temp .md file (enforce formatting rules below)
2. Copy to remote vault: `scp <filepath> user@remote-host:/path/to/obsidian/vault/`
3. Confirm success to user

**Example:**
```bash
# Write content to temp file
cat > /tmp/my-note.md << 'EOF'
# My Note
Content here
EOF

# Copy to remote Obsidian vault
scp /tmp/my-note.md myuser@vault.example.com:~/Obsidian/MyVault/

# Clean up
rm /tmp/my-note.md
```

**Configuration:** The agent should use the SSH host and vault path configured in workspace TOOLS.md

## Formatting Rules

All content saved to Obsidian MUST follow these rules:

### Diagrams: Use Mermaid (mandatory)
- **Never** use ASCII box diagrams, ASCII art, or plaintext diagrams
- **Always** use Mermaid fenced code blocks (` ```mermaid `)
- Obsidian renders Mermaid natively — ASCII diagrams look broken
- Supported types: flowchart, sequence, state, class, ER, gantt, pie, mindmap, timeline, quadrant, graph

### Tables: Use Markdown tables
- Obsidian renders markdown tables natively
- For complex data, prefer tables over bullet lists

### Links: Use wiki-links or relative links
- Link between Obsidian notes: `[[note-name]]`
- External links: standard markdown `[text](url)`

### General
- Use headers (##) for structure — Obsidian outline panel relies on them
- Use YAML frontmatter if metadata is needed
- Keep filenames kebab-case (no spaces) for cross-platform compatibility

## Agent Owner
This skill is executed by the main OpenClaw agent session. The `save-to-obsidian.sh` script
runs as a shell command via the exec tool. No sub-agents are spawned. iCloud sync is handled
automatically after file transfer — no agent action needed.

## Success Criteria
Save succeeds when:
1. scp exits with code 0
2. File appears in vault directory with correct filename
3. iCloud sync propagates the file (typically 1-2 minutes; not verified by skill)

Failure conditions: SSH unreachable, vault path does not exist, disk full, filename
contains characters invalid for iCloud sync (handled by sanitization in script).

## Edge Cases
- **SSH failure**: script exits with error message and non-zero code; agent should report and stop
- **Duplicate filename**: overwrites silently — scp does not warn; user must check if overwrite is desired
- **Special characters in filename**: sanitized by script (spaces → hyphens, invalid chars stripped)
- **Empty content**: scp will transfer a 0-byte file; not an error but should be flagged
- **No clear title**: if content has no H1 header, agent should prompt user for filename before saving
- **iCloud sync delay**: file appears in vault within 1-2 min; if not visible after 5 min, check iCloud status

## Notes

- Uses existing SSH key auth (no password)
- Target: remote-host → Obsidian vault location
- Files sync via iCloud automatically (if vault is in iCloud folder)

## Configuration

This skill reads SSH and vault configuration from your workspace TOOLS.md:

| Variable | Description | Where to set |
|----------|-------------|--------------|
| SSH host | Hostname/IP of the remote machine hosting the Obsidian vault | TOOLS.md (e.g., `myserver.local`) |
| SSH user | Username on the remote machine | TOOLS.md (e.g., `your-username`) |
| SSH key path | Path to SSH private key (default: `~/.ssh/id_rsa`) | TOOLS.md |
| Vault path | Absolute path to Obsidian vault on remote machine | TOOLS.md (e.g., `~/Obsidian/MyVault/`) |

**Example TOOLS.md entry:**
```
## Obsidian Remote Vault
- SSH host: myserver.local
- SSH user: your-username
- Vault path: ~/Obsidian/MyVault/
```

No API keys or tokens required — uses SSH key authentication only.
