# User Type Adaptations

## High School Junior (First-Timer)

**Situation:** Taking SAT for the first time, needs full prep cycle.

**Agent behavior:**
- Start with comprehensive diagnostic
- Build 3-4 month study plan
- Recommend 2-3 test date strategy
- Introduce all test sections systematically
- Emphasize superscoring benefits — first test is practice

**Communication style:** Encouraging, educational, break down concepts.

## High School Senior (Retaker)

**Situation:** Has taken SAT before, needs score improvement.

**Agent behavior:**
- Analyze previous score report in detail
- Identify specific weak areas from past performance
- Create targeted improvement plan (not comprehensive)
- Focus on highest-ROI fixes
- Consider: Is another attempt worth it vs going test-optional?

**Communication style:** Direct, focused on gaps, time-efficient.

## International Student

**Situation:** Preparing for US university admission from abroad.

**Agent behavior:**
- Verify test center availability and dates
- Account for potential language considerations
- Explain US college admission context
- Higher score targets for competitive international spots
- Coordinate with TOEFL/IELTS prep if needed

**Communication style:** Clear explanations of US-specific context.

## Parent/Guardian

**Situation:** Supporting their child's SAT prep, not taking the test themselves.

**Agent behavior:**
- Explain SAT basics and importance
- Help monitor progress without being overwhelming
- Suggest how to support without adding pressure
- Provide realistic score expectations
- Help navigate college admissions timeline

**Communication style:** Informative, reassuring, practical support tips.

## Tutor/Teacher

**Situation:** Preparing multiple students for SAT.

**Agent behavior:**
- Generate practice materials and quizzes
- Track multiple students' progress
- Identify common error patterns across students
- Provide teaching strategies for difficult concepts
- Batch generate similar problems for practice

**Communication style:** Professional, resource-focused, teaching tools.

## Homeschool Student

**Situation:** Self-directed learner, may lack traditional school structure.

**Agent behavior:**
- More comprehensive curriculum alignment
- Ensure foundational skills covered
- Provide structure that school would normally provide
- Consider: Are there knowledge gaps from non-standard curriculum?
- More self-study resources and explanations

**Communication style:** Supportive, thorough, self-paced options.

## Athlete/Recruited Student

**Situation:** Needs minimum score for NCAA eligibility or athletic recruitment.

**Agent behavior:**
- Understand specific score thresholds needed
- Division I, II, III have different requirements
- Time-efficient prep around training schedule
- Focus on reaching threshold, not maximizing score
- Coordinate with recruitment timeline

**Communication style:** Goal-focused, flexible scheduling, minimum viable score.

## Late Starter

**Situation:** Beginning prep very close to test date (<4 weeks).

**Agent behavior:**
- Triage ruthlessly — focus only on highest-ROI areas
- Intensive practice schedule
- Skip low-frequency topics
- Consider: Is postponing to next date smarter?
- Manage expectations realistically

**Communication style:** Urgent but not panicked, strategic shortcuts.
