# Test-Taking Techniques

## General Principles

### Time Management
- RW: ~1.2 min per question (64 min / 54 questions)
- Math: ~1.6 min per question (70 min / 44 questions)
- Don't get stuck — flag and move on
- Digital SAT has built-in timer per section

### Answer Every Question
- No penalty for wrong answers
- Never leave anything blank
- If stuck, eliminate obviously wrong answers, then guess

### Read Questions First
For RW passages: Read the question before the passage
- You know what to look for
- Saves time on re-reading

### Use Process of Elimination
Most questions have 1-2 obviously wrong answers
- Eliminate first
- Then choose from remaining
- Even educated guessing improves odds

## Reading & Writing Techniques

### Evidence-Based Questions
- Answer must be supported by the passage
- If you can't point to specific text, it's probably wrong
- Avoid answers that "sound right" but aren't stated

### Vocabulary in Context
- Don't pick the first definition you know
- Read the sentence with each answer choice
- Choose the one that maintains the passage's meaning

### Grammar Questions
- Read the whole sentence, not just the underlined part
- Check for subject-verb agreement first
- When in doubt, simpler is usually better

### Transitions
- Understand what comes before AND after
- Common trap: choosing a transition that only fits one direction
- Types: addition, contrast, cause/effect, sequence

## Math Techniques

### Use the Calculator Wisely
- Desmos built-in — learn it before test day
- Graph equations to visualize
- Don't over-rely — mental math is faster for simple problems

### Plug In Answers
When algebra is complex:
1. Start with answer B or C
2. Plug into the equation
3. See if it works
4. Adjust up/down based on result

### Plug In Numbers
For abstract problems with variables:
1. Choose simple numbers (2, 3, 5)
2. Solve with those numbers
3. Check which answer gives the same result

### Draw It Out
For geometry and word problems:
- Sketch the situation
- Label known values
- Often reveals the path to solution

### Check Units
In word problems:
- Units must make sense
- Miles per hour × hours = miles (not hours/mile)
- Catches careless errors

## Module 1 Strategy

Remember: Module 1 determines Module 2 difficulty.

- Don't rush through Module 1
- Double-check answers before submitting
- Strong Module 1 = higher score ceiling in Module 2
- A few extra minutes of care pays off

## Flagging Strategy

Digital SAT allows flagging questions:
1. First pass: Answer everything you can quickly
2. Flag anything taking >90 seconds
3. Second pass: Return to flagged questions
4. Third pass: Quick review of all answers if time remains

## Test Day

### Before the Test
- Sleep 8+ hours (not just the night before — several days)
- Eat a normal breakfast
- Arrive early
- Bring: ID, admission ticket, approved calculator (backup), snacks for break

### During the Test
- Use the break (10 min between RW and Math)
- Stretch, use restroom, have a snack
- Don't discuss questions during break

### Mindset
- Expect some hard questions — everyone gets them
- One hard question doesn't affect the next
- Stay calm, stick to your strategies
