# Study Strategies

## Study Plan Framework

### Phase 1: Diagnostic (Week 1)
1. Take full practice test under real conditions
2. Score and analyze by section/domain
3. Identify top 3 weakness areas
4. Set realistic target score based on baseline

### Phase 2: Foundation Building (Weeks 2-4)
Focus on highest-ROI weaknesses:
- If Math < 650: Prioritize algebra fundamentals
- If RW < 650: Prioritize grammar rules and vocabulary
- Daily: 1 hour focused practice on weak areas
- Weekly: 1 full section timed practice

### Phase 3: Intensive Practice (Weeks 5-8)
- 2-3 full practice tests per week
- Deep analysis of every mistake
- Timed section drills
- Focus shifting to test-taking strategies

### Phase 4: Final Prep (Week before test)
- Light review only — no cramming
- Review mistake log for patterns
- One easy practice test for confidence
- Rest and sleep prioritized

## Weekly Structure

| Day | Activity | Duration |
|-----|----------|----------|
| Mon | Weak area drilling | 60 min |
| Tue | Timed section (RW) | 64 min + review |
| Wed | Weak area drilling | 60 min |
| Thu | Timed section (Math) | 70 min + review |
| Fri | Vocabulary/formulas | 30 min |
| Sat | Full practice test | 2.5 hours |
| Sun | Test review + mistake log | 60 min |

Adjust based on available time. Minimum: 10 hrs/week for meaningful improvement.

## Points-per-Hour Priority

Not all topics are equal. Focus on high-frequency, high-point areas:

**High ROI (always prioritize):**
- Linear equations (Math) — 5-7 questions per test
- Grammar fundamentals (RW) — 8-10 questions per test
- Reading comprehension basics (RW) — appears throughout

**Medium ROI:**
- Quadratics and functions
- Data interpretation
- Punctuation rules

**Lower ROI (address if time permits):**
- Advanced trig
- Complex geometry
- Obscure vocabulary

## Spaced Repetition for Vocabulary

SAT tests "words in context" — not pure definitions.

1. Add new words to `~/sat/vocabulary/`
2. Include: word, definition, example sentence, SAT-style usage
3. Review schedule: Day 1, 3, 7, 14, 30
4. Test in context, not isolation

## Practice Test Sources

Official sources (use these):
- College Board Bluebook app (free, official)
- Khan Academy SAT prep (free, official partnership)
- College Board practice tests on website

Supplement sources:
- Major test prep books (Kaplan, Princeton Review, etc.)
- Note: Non-official tests may differ in difficulty/style
