# SAT Exam Format (Digital SAT)

## Structure (as of 2024)

| Section | Modules | Time | Questions |
|---------|---------|------|-----------|
| Reading & Writing | 2 | 64 min total | 54 |
| Math | 2 | 70 min total | 44 |
| **Total** | 4 | 2h 14min | 98 |

## Adaptive Testing

The Digital SAT uses multistage adaptive testing (MST):
- Module 1: Mix of easy, medium, hard questions
- Module 2: Difficulty based on Module 1 performance
- Strong Module 1 → harder Module 2 → higher score ceiling
- Weak Module 1 → easier Module 2 → lower score ceiling

**Implication:** First module performance is critical. Don't rush.

## Scoring

| Section | Score Range |
|---------|-------------|
| Reading & Writing | 200-800 |
| Math | 200-800 |
| **Total** | 400-1600 |

**Superscoring:** Many colleges take best section scores across multiple test dates. Plan attempts accordingly.

## Reading & Writing Content

| Domain | % of Section | Focus |
|--------|--------------|-------|
| Craft and Structure | 28% | Word meaning, text structure, purpose |
| Information and Ideas | 26% | Central ideas, details, inferences |
| Standard English Conventions | 26% | Grammar, punctuation, sentence structure |
| Expression of Ideas | 20% | Transitions, rhetorical synthesis |

Key shift from old SAT: Shorter passages, one question per passage.

## Math Content

| Domain | % of Section | Topics |
|--------|--------------|--------|
| Algebra | 35% | Linear equations, systems, functions |
| Advanced Math | 35% | Quadratics, polynomials, exponentials |
| Problem-Solving & Data | 15% | Ratios, percentages, statistics |
| Geometry & Trig | 15% | Area, volume, triangles, circles, trig |

Calculator allowed on ALL math questions (built-in Desmos).

## Test Dates (Typical US Schedule)

- August, October, November, December
- March, May, June

International dates vary. Check collegeboard.org for specific dates.

## Registration

- Register at collegeboard.org
- Deadline typically 4 weeks before test
- Late registration available with fee
- Score reports: ~2 weeks after test
