# College Admissions Planning

## Score Targets by College Tier

| Tier | Examples | Target Score |
|------|----------|--------------|
| Elite (Ivy+) | Harvard, MIT, Stanford | 1550+ |
| Highly Selective | Duke, Northwestern, UCLA | 1500+ |
| Selective | Boston U, UC Davis, NYU | 1400+ |
| Competitive | State flagships, good privates | 1300+ |
| Less Selective | Regional schools | 1200+ |

**Note:** These are middle-50% ranges. Above average increases chances; below doesn't disqualify.

## Test-Optional Landscape

Many colleges are now test-optional. Strategy:
- **Score above 50th percentile for the school** → Submit
- **Score below 25th percentile** → Don't submit
- **Score in between** → Consider full application context

Check each school's policy — changes year to year.

## Superscoring Strategy

Most selective colleges superscore (take best section scores across dates).

**Example:**
- Test 1: RW 720, Math 680 → 1400
- Test 2: RW 690, Math 730 → 1420
- Superscore: RW 720 + Math 730 → **1450**

**Strategy:**
1. Plan 2-3 test dates
2. After first test, focus prep on weaker section
3. Even if total drops, superscore may improve

**Schools that DON'T superscore:** Some state schools, international universities. Verify policy.

## Score Choice

SAT offers Score Choice — you can choose which test dates to send.
- Most colleges see all scores OR accept Score Choice
- Georgetown requires all scores
- Check each school's policy

## Timeline Planning

### Junior Year
- Fall: Diagnostic, begin prep
- Spring: First SAT attempt (March or May)
- Summer: Intense prep if needed

### Senior Year
- August/October: Final attempts
- November: Last chance for regular decision
- December: Some schools accept for RD

**Don't wait until senior fall** — earlier attempts reduce pressure.

## International Students

Additional considerations:
- SAT accepted at most US universities
- Some require English proficiency (TOEFL/IELTS) separately
- Test centers may be limited — register early
- Score expectations often higher for competitive international spots

## Beyond the Score

SAT is ONE factor. Colleges also evaluate:
- GPA and course rigor
- Essays
- Extracurriculars
- Recommendations
- Demonstrated interest (for some schools)

A good SAT opens doors; it doesn't guarantee admission.

## Financial Aid Impact

Some merit scholarships are score-based:
- Many schools offer automatic merit aid at score thresholds
- Example: "1450+ = $15,000/year scholarship"
- Check each school's merit aid matrix
- Can justify extra prep investment

## Building a College List

Use SAT score to build a balanced list:
- **Reach schools:** Your score at or below 25th percentile
- **Match schools:** Your score near 50th percentile
- **Safety schools:** Your score above 75th percentile

Aim for: 2-3 reach, 4-5 match, 2-3 safety
