# SAP FICO Expert — OpenClaw Skill

## 📋 Overview

| Property | Value |
|----------|-------|
| **Name** | `sap-fico-expert` |
| **Version** | 1.0.0 |
| **Platform** | OpenClaw (Telegram / Social platforms) |
| **Target LLM** | DeepSeek Chat (explanations) / DeepSeek Coder (ABAP) |
| **Language** | French technical SAP terminology |
| **Author** | @chanfouricc |

## 🎯 Objective

Transform any OpenClaw bot into a **Senior SAP Finance & Controlling consultant** capable of answering configuration, troubleshooting, cross-module integration, and S/4HANA migration questions with production-grade accuracy.

## 📁 Skill Structure

```
sap-fico-skill/
├── SKILL.md                  # This documentation
├── skill.json                # OpenClaw skill configuration
├── system_prompt.md          # Full system prompt (to inject)
├── examples.json             # Calibrated few-shot Q&A examples
└── reference/
    ├── tcodes_index.md       # T-code index by domain
    ├── tables_index.md       # Critical SAP tables index
    └── error_codes.md        # Common FI/CO error messages
```

## 🚀 Installation on OpenClaw

### 1. Copy the skill to your VPS

```bash
scp -r sap-fico-skill/ user@vps:/opt/openclaw/skills/
```

### 2. Register the skill in OpenClaw

Add to your OpenClaw configuration (`config.json` or equivalent):

```json
{
  "skills": {
    "sap-fico-expert": {
      "enabled": true,
      "trigger": "auto",
      "keywords": ["SAP", "FICO", "FI-GL", "FI-AP", "FI-AR", "FI-AA", "CO-CCA", "CO-PA", "CO-PC", "ACDOCA", "S/4HANA", "T-code", "BKPF", "BSEG", "OB52", "FB01", "KS01"],
      "system_prompt_path": "skills/sap-fico-expert/system_prompt.md",
      "examples_path": "skills/sap-fico-expert/examples.json",
      "model_override": "deepseek-chat",
      "parameters": {
        "max_tokens": 600,
        "temperature": 0.25,
        "presence_penalty": 0.1
      }
    }
  }
}
```

### 3. Trigger activation

The skill activates automatically when a message contains an SAP keyword. Alternatively, users can force activation with:

```
/skill sap-fico-expert
```

## 🔧 Recommended Settings

| Parameter | Value | Rationale |
|-----------|-------|-----------|
| `temperature` | 0.25 | Deterministic — no creativity on SAP config |
| `max_tokens` | 600 | Increased from initial spec (450 too short for complex questions) |
| `presence_penalty` | 0.1 | Slight lexical diversity without drift |
| `model` | `deepseek-chat` | Default; switches to `deepseek-coder` when ABAP detected |

> ⚠️ **Note**: The original 450 token limit was raised to 600. Responses involving cross-module integrations or S/4HANA migrations need more space to remain actionable.

## 📊 Coverage

### Tier 1 — Core expertise (immediate answers)
- Configuration: FI-GL, FI-AP, FI-AR, FI-AA, FI-BL
- Configuration: CO-CCA, CO-PA, CO-PC, CO-OPA
- Period-end & year-end closing
- Automatic account determination (FI-MM, FI-SD)
- T-codes, tables, customizing transactions

### Tier 2 — Advanced expertise (detailed answers)
- S/4HANA Universal Journal (ACDOCA)
- ECC → S/4HANA migration (Brownfield/Greenfield)
- SAP Cloud Public Edition specifics
- Central Finance & Group Reporting
- Troubleshooting error messages Fxxx/Kxxx

### Tier 3 — Integration expertise (contextual answers)
- FI-PP (Production order settlement)
- FI-HR (Payroll integration)
- FI-PS (Project settlement)
- Intercompany processing & reconciliation
- Tax reporting (VAT, Withholding tax, Intrastat)

## 🧪 Testing

### Quick validation questions

| # | Test question | Verify |
|---|--------------|--------|
| 1 | "How to configure document splitting in S/4HANA?" | T-code + tables + steps |
| 2 | "Error F5 025 when posting" | Diagnosis + solution + config |
| 3 | "Difference between assessment and distribution in CO?" | Explanation + T-codes + use cases |
| 4 | "How does GR/IR clearing work?" | Process + FI-MM integration + T-codes |
| 5 | "Migrate FI-AA to New Asset Accounting" | Steps + tables + S/4HANA specifics |

### Quality criteria

- ✅ T-code mentioned on the first line
- ✅ Relevant SAP tables listed
- ✅ Configuration referenced when applicable
- ✅ Cross-module impacts flagged
- ✅ S/4HANA differences mentioned when relevant
- ✅ Expert but accessible tone
- ✅ Response in French technical SAP terminology

## 📝 Changelog

| Version | Date | Changes |
|---------|------|---------|
| 1.0.0 | 2026-02-08 | Initial release — full FI/CO coverage |
