# Transportation Guide — San Francisco

## Overview

**Key insight:** SF is best navigated WITHOUT a car. Parking is expensive ($200-400/month), car break-ins are rampant, and transit covers most areas.

## Public Transit

### MUNI (SF Municipal Transit)
The city's bus, streetcar, and metro system.

| Type | Coverage | Notes |
|------|----------|-------|
| **MUNI Metro** | Underground downtown, surface in neighborhoods | L, M, N, K/T, J lines |
| **MUNI Bus** | Everywhere | Many routes |
| **Historic Streetcars** | Market St to Fisherman's Wharf | F-line |
| **Cable Cars** | Tourist areas | Powell-Mason, Powell-Hyde, California |

**Fares:**
- Single ride: $2.50 (exact change or Clipper)
- Day pass: $13
- Monthly pass (MUNI only): ~$81
- Monthly pass (MUNI + BART): ~$98

**Free rides:**
- Under 18: FREE
- Seniors 65+: Reduced fare
- Low-income discount: Available

### BART (Bay Area Rapid Transit)
Regional rail connecting SF to East Bay, SFO, and Peninsula.

**SF Stations:** Embarcadero, Montgomery, Powell, Civic Center, 16th St, 24th St, Balboa Park, Glen Park

**Fares:** Distance-based, $2.40 minimum
- SF to Oakland: ~$4-5
- SF to Berkeley: ~$5-6
- SF to SFO Airport: ~$9-10

**Hours:** ~5am-midnight (limited late night)

### Caltrain
Commuter rail to Peninsula and South Bay (Palo Alto, Mountain View, San Jose).

- **SF Station:** 4th & King (SoMa)
- **Fare to Palo Alto:** ~$7-10
- **Monthly pass:** ~$250 from SF
- **Tech shuttles:** Connect Caltrain to Google, Meta, etc.

### Ferry
Scenic option for commute or tourism.

| Route | Fare | Notes |
|-------|------|-------|
| SF ↔ Sausalito | ~$14 | Tourist favorite |
| SF ↔ Oakland | ~$7 | Commuter route |
| SF ↔ Larkspur | ~$14 | Marin County |
| SF ↔ Vallejo | ~$15 | North Bay |

**Terminal:** Ferry Building (Embarcadero)

### Clipper Card (Essential)
- **What:** Reloadable transit card for ALL Bay Area transit
- **Where to get:** Walgreens, BART stations, clippercard.com
- **Load:** Cash, credit, auto-reload
- **Tip:** Get a Clipper card immediately — way easier than cash

## Rideshare & Taxis

### Uber/Lyft
- **Ubiquitous** in SF
- **Typical costs:**
  - Downtown to Mission: $12-18
  - Downtown to Marina: $15-22
  - Downtown to SFO: $35-55
- **Surge pricing:** Common during events, rain, weekend nights
- **Tip:** Lyft often slightly cheaper than Uber

### Taxis
- **Still exist** but less common
- **Apps:** Flywheel, Curb
- **When useful:** Credit card issues, prefer traditional

## Bikes & Scooters

### Bay Wheels (Bike Share)
- **Operator:** Lyft
- **Stations:** Throughout SF
- **Cost:** $3.50/trip (30 min), $25/month membership
- **E-bikes:** Available, extra cost
- **Good for:** Flat areas (Embarcadero, Marina, Mission)

### Electric Scooters
- **Available:** Lime, Spin, others
- **Cost:** $1 to unlock + $0.30-0.40/min
- **Rules:** No sidewalk riding, must use bike lanes
- **Helmet:** Required by law (though rarely enforced)

### Bike Lanes
- **Best routes:** Embarcadero, Panhandle, Wiggle (flat route to Ocean Beach)
- **Caution:** Hills are brutal, SF has serious elevation
- **E-bike recommended** for regular commuting

## Driving & Parking

### Should You Have a Car?
**Probably not if:**
- You live/work in central SF
- Your commute is BART/MUNI accessible
- You don't leave the city often

**Maybe yes if:**
- You commute to South Bay (no public transit option)
- You have kids and frequently leave city
- You live in outer neighborhoods with poor transit

### Parking Costs
- **Garage (downtown):** $300-600/month
- **Residential permit:** ~$150/year (lottery in popular areas)
- **Street parking:** Free with permit in residential areas
- **Meters:** $2-8/hour depending on area

### Car Break-Ins (Critical Warning)
- SF has **highest rate in the country**
- **Never leave anything visible** — empty bag = smashed window
- Worst areas: tourist spots, Fisherman's Wharf, downtown
- **Tips:**
  - Leave glove box open (shows empty)
  - Trunk should be empty BEFORE you park
  - Use garages when possible

### Tolls
- **Golden Gate Bridge:** ~$8.75 (southbound only, electronic)
- **Bay Bridge:** ~$7 (westbound only, electronic)
- **FasTrak:** Get it if driving regularly

## Getting to/from Airports

### SFO (San Francisco International)
- **BART:** Direct, ~$9-10, 35-45 min to downtown
- **Uber/Lyft:** $35-55, 25-45 min depending on traffic
- **Shuttle:** SuperShuttle, ~$20-30

### OAK (Oakland International)
- **BART + connector:** ~$12, 60+ min
- **Uber/Lyft:** $40-60, 30-45 min
- **Often cheaper flights** than SFO

### SJC (San Jose International)
- **Caltrain + VTA:** ~$15, 90+ min
- **Uber/Lyft:** $60-90, 50-70 min
- **Only worth it** if significantly cheaper flight

## Transit Apps

| App | Purpose |
|-----|---------|
| **Google Maps** | Best overall for trip planning |
| **Apple Maps** | Good transit directions |
| **SFMTA app** | Official MUNI arrivals |
| **BART app** | Official BART times |
| **Transit** | Real-time arrivals, multiple agencies |
| **Citymapper** | Excellent multi-modal planning |

## Tips from Locals

- **511.org** — Regional trip planner and alerts
- **Avoid rush hour MUNI** — 8-9am, 5-6pm very crowded
- **N-Judah** — Slowest line, budget extra time
- **Cable cars** — Fun once, not practical for commuting
- **Uber pool/Lyft shared** — Cheaper, takes longer
- **BART parking** — Free on weekends at some stations
- **Fog delays** — Can affect Marin ferries and outer MUNI
