# Tech Worker Guide — San Francisco Bay Area

## Major Employers & Office Locations

### Mega Giants (Public Companies)

| Company | HQ Location | Bay Area Employees | Focus |
|---------|-------------|-------------------|-------|
| **Apple** | Cupertino (Apple Park) | 25,000+ | Consumer hardware/software |
| **Google/Alphabet** | Mountain View + SF | 30,000+ | Search, cloud, AI |
| **Meta** | Menlo Park | 15,000+ | Social, VR/AR |
| **Salesforce** | SF (Salesforce Tower) | 12,000+ in SF | Enterprise SaaS |
| **Amazon/AWS** | SF + Palo Alto | 8,000+ | Cloud, retail |

### Unicorns & Growth Companies

| Company | Location | Valuation | Sector |
|---------|----------|-----------|--------|
| **OpenAI** | Mission District/Mission Bay | $90B+ | AI |
| **Anthropic** | SF | $40B+ | AI Safety |
| **Stripe** | SF (South Park) | $95B | Fintech |
| **Airbnb** | SF | $75B+ | Travel |
| **Uber** | SF (Mission Bay) | $120B+ | Mobility |
| **DoorDash** | SF | $50B+ | Delivery |
| **Cloudflare** | SF | $25B+ | Infrastructure |

### Office Zones

- **SF Downtown/SoMa:** Salesforce, Uber, Airbnb, Cloudflare, Twilio, DocuSign
- **Mission Bay:** OpenAI, UCSF, biotech hub
- **South Bay:** Google, Apple, Meta (Mountain View/Palo Alto/Cupertino)
- **Biotech Corridor:** South SF, Brisbane (Genentech hub)

## Salary Benchmarks (Total Compensation)

### Software Engineer by Level

| Level | Total Comp Range | Base Typical |
|-------|-----------------|--------------|
| Entry (L3/New Grad) | $130K-180K | $110-140K |
| Mid (L4/SDE II) | $200K-290K | $150-180K |
| Senior (L5) | $300K-400K | $180-220K |
| Staff (L6) | $400K-550K | $220-280K |
| Principal (L7+) | $550K-800K+ | $280-350K |

### By Company (Median Total Comp)

| Company | L4 (SDE II) | L5 (Senior) | L6 (Staff) |
|---------|-------------|-------------|------------|
| **OpenAI** | $350K | $630K | $1M+ |
| **Google** | $260K | $350K | $500K |
| **Meta** | $280K | $380K | $550K |
| **Apple** | $240K | $320K | $450K |
| **Amazon** | $210K | $290K | $450K |
| **Stripe** | $280K | $380K | $500K |
| **Salesforce** | $220K | $290K | $380K |

**Note:** AI/ML roles pay 20-40% premium over base SWE

### Compensation Reality Check

- **$150K base ≈ $80K elsewhere** — SF cost of living is brutal
- **Stock comp is real** — Total comp matters more than base
- **AI premium is huge** — OpenAI, Anthropic pay significantly more

## Work Culture (2025)

### Remote/Hybrid Trends
- Office vacancy rate: 37% (historic high)
- Typical model: 3 days office / 2 remote
- **Full remote:** GitLab, Zapier, some startups
- **Strict RTO:** Amazon (5 days), some fintech

### Culture Variations
- **Big Tech:** Better WLB, premium benefits, more process
- **Startups:** Intense, equity-heavy compensation
- **AI Companies:** High intensity, top salaries

### Layoff Context (2023-2025)
- Major layoffs in 2022-2023 (Meta, Google, Amazon)
- AI companies hiring aggressively
- Market more competitive than 2021 peak

## Best Neighborhoods for Tech Workers

### Near SF Offices

| Neighborhood | For | Commute to SoMa |
|--------------|-----|-----------------|
| **Mission** | Young, social, sunny | 10-15 min MUNI |
| **Hayes Valley** | Central, walkable | 10 min walk |
| **SoMa** | Ultra-close | Walk |
| **Potrero Hill** | Quieter, views | 10 min |

### Near South Bay (Google/Apple/Meta)

| Option | Trade-off |
|--------|-----------|
| **Live in SF, commute** | Tech shuttle (~1hr each way), WLB hit |
| **Live in Palo Alto/MV** | Closer to work, quieter, suburban |
| **Live on Peninsula** | San Mateo, Redwood City — middle ground |

### Tech Shuttle Reality
- Google, Apple, Meta, Genentech run private buses
- WiFi + work on commute
- 45-90 min each way depending on pickup
- Popular: pick up in Mission, Castro, Marina

## Networking & Events

### Major Conferences (2025)

| Event | Date | Location | Focus |
|-------|------|----------|-------|
| **TechCrunch Disrupt** | Oct 27-29 | Moscone West | Startups, VCs |
| **SaaStr Annual** | May 13-15 | San Mateo | B2B SaaS |
| **Dreamforce** | Oct 14-16 | Moscone | Enterprise (Salesforce) |
| **RSA Conference** | Apr 28-May 1 | Moscone | Cybersecurity |
| **TEDAI SF** | Oct 21-22 | SF | AI Leaders |

### Regular Meetups
- **Bay Area AI Meetup** — Technical AI/ML events
- **Cerebral Valley** — AI event hub, hackathons
- **SF #TechWeek** — Annual week of tech events
- **Product Hunt SF** — Product launches
- **Y Combinator Demo Days** — 2x/year

### Casual Networking
- **Running clubs** — Founders Running Club
- **Hacker houses** — AGI House, Treehouse
- **Coworking events** — Shack15, Industrious

## Visa & Sponsorship

### Common Work Visas
- **H-1B:** Specialty occupation, lottery-based, employer-sponsored
- **L-1:** Intracompany transfer
- **O-1:** Extraordinary ability
- **E-2:** Treaty investor (startups)

### Companies Known for Sponsorship
- Most large tech companies sponsor H-1B
- Check levels.fyi for company-specific visa data
- AI companies aggressively sponsoring talent

## Career Growth Tips

### Standing Out
- **Build in public** — GitHub, blog, Twitter/X
- **Attend events** — In-person networking matters
- **Specialize in AI** — Premium skills pay premium salaries
- **Network at work** — Internal mobility is easier

### Negotiation Reality
- **Always negotiate** — Companies expect it
- **Total comp focus** — Stock, signing bonus, benefits
- **Competing offers help** — Interview broadly
- **levels.fyi** — Check realistic comp ranges before negotiating
