# Student Guide — San Francisco Bay Area

## Universities

### In San Francisco (City)

| University | Type | Annual Tuition | Acceptance |
|------------|------|----------------|------------|
| **SF State (SFSU)** | Public (CSU) | $7,500 + fees = ~$25,500 (in-state) / $37,400 (out-of-state) | 93% |
| **USF** | Private (Jesuit) | ~$58,000 | ~65% |
| **UCSF** | Public (UC) - Graduate Only | N/A (medical/nursing/pharma) | Very selective |
| **City College SF** | Community College | ~$1,400/year (in-state) / ~$10,000 (out-of-state) | Open admission |
| **Academy of Art** | Private (For-profit) | ~$24,000 | Open admission |

### Bay Area (Nearby)

| University | Distance | Total Cost/Year | Notes |
|------------|----------|-----------------|-------|
| **UC Berkeley** | 30 min BART | ~$45,000 (in-state COA) | Top 20 globally |
| **Stanford** | 45 min Caltrain | ~$96,500 | Includes housing |
| **San Jose State** | 1hr Caltrain | ~$23,000 (in-state) | Good for tech |
| **Santa Clara Univ** | 50 min | ~$60,000 | Jesuit, strong CS |

## Detailed Cost Breakdown

### UC Berkeley (2025-2026)
```
Tuition + Fees:       $14,312 (CA) / $51,914 (Non-resident)
Housing + Food:       $22,167 (on-campus)
Books & Supplies:     $1,442
Personal:             $2,738 - $3,006
Transportation:       $830 - $2,998
---
TOTAL:                ~$42,000 (CA) / ~$79,000 (Non-res)
```

### Stanford
```
Tuition:              $67,731
Housing + Food:       $22,167
Student Fees:         $2,475
Books:                $840
Personal:             $3,300
---
TOTAL:                $96,513+
```

### SFSU (Most Affordable)
```
In-state total COA:   $25,479
Out-of-state:         $37,359
Net cost (low income): $9,000 - $13,000
```

## Financial Aid

### Grants (No Repayment)
- **Cal Grant:** Up to $12,630/year for CA residents (income-based)
- **Pell Grant:** Up to $7,395/year (federal)
- **SFSU Grant:** Additional need-based aid
- **Stanford:** 100% need-met policy (families <$100K = no tuition)
- **Berkeley Blue+Gold:** Families <$85K = no tuition

### Key Deadlines
- FAFSA: Opens October 1, priority by March 2
- Cal Grant: March 2 deadline

## Housing Options

### On-Campus (Per Year)

| University | Range | Includes |
|------------|-------|----------|
| SFSU | $10,000-14,000 | Housing + basic meal plan |
| Berkeley | $18,000-22,000 | Residence halls |
| Stanford | $22,167 | Housing + full meal |
| USF | $16,000-18,000 | Housing |

### Off-Campus (Monthly)

| Option | Cost | Best For |
|--------|------|----------|
| **Studio** | $1,800-2,500 | Privacy seekers |
| **1BR** | $2,400-3,200 | Couples |
| **Room share** | $900-1,500 | Budget-conscious |

### Budget-Friendly Areas
- **Outer Sunset** — Foggy, quiet, near SFSU
- **Daly City** — 50% cheaper, BART accessible
- **Parkmerced** — Near SFSU, student-friendly
- **Colma** — BART line, very affordable

### Where to Search
- **Craigslist SF** (sfbay.craigslist.org) — Most used
- **Facebook Groups:** "SF Housing", "Bay Area Rentals"
- **Roomies.com, SpareRoom** — Roommate matching
- **University housing boards** — Each school has one

## Part-Time Work

### On-Campus (Recommended for F-1 visa)

| Job | Pay | Notes |
|-----|-----|-------|
| Work-study | $17-20/hr | Library, tutoring, admin |
| Research assistant | $18-25/hr | Undergrad positions |
| Dining halls | $17-19/hr | Flexible hours |
| IT help desk | $18-22/hr | Tech experience |
| Campus tour guide | $17-20/hr | Social |

### Off-Campus Popular Jobs

| Job | Pay | Flexibility |
|-----|-----|-------------|
| Barista (Blue Bottle, Peet's) | $17-20/hr + tips | Medium |
| Retail (Union Square) | $17-19/hr | Variable |
| Food delivery (DoorDash) | $15-25/hr | High |
| Tutoring (Wyzant, Varsity) | $25-60/hr | High |
| Restaurant server | $17/hr + tips (~$30 total) | Variable |

### Apps for Gigs
- **Handshake** — University job board
- **LinkedIn** — Professional roles
- **DoorDash/UberEats** — Flexible delivery
- **Snagajob** — Hourly positions

## Student Transportation

### MUNI (SF Transit)
- **Under 18:** FREE
- **Adult single ride:** $2.50
- **Monthly pass:** ~$81

### BART (Regional)
- **Connects:** SF ↔ Berkeley ↔ Oakland ↔ Airport
- **Student discount:** 50% off with BART student ID
- **To Berkeley:** ~$4-5 one way

### Caltrain (Peninsula)
- **To Stanford:** ~$7-10 one way
- **Monthly pass:** ~$250 (from SF)

### Clipper Card
- **Essential:** Load all transit on one card
- **Auto-reload:** Set up for convenience
- **Get at:** Walgreens, BART stations, online

## Student Life

### Study Spots
- **SF Public Library (Main)** — Free, downtown
- **Coffee shops:** Sightglass, Four Barrel, Ritual
- **Berkeley:** Free Speech Movement Café, Doe Library
- **Stanford:** Green Library, CoHo

### Social & Activities
- **Mission Dolores Park** — Young crowd, weekend hangout
- **Golden Gate Park** — Picnics, sports
- **Ocean Beach** — Bonfires (bring layers)
- **Berkeley events** — Free concerts, speakers

### Cheap Eats
- **Mission burritos** — $12-15, huge portions
- **Chinatown** — $8-12 meals
- **Trader Joe's** — Budget groceries
- **Costco** — Stock up with roommates

## Safety for Students

### Safe Areas
- **Most campus areas** — Generally safe
- **Mission** — Fine during day, careful at night
- **Berkeley campus** — Safe, some surrounding areas less so

### Areas to Avoid
- **Tenderloin** — Avoid especially at night
- **Civic Center** — Late night risky
- **Parts of Oakland** — Varies by neighborhood

### General Tips
- Don't walk alone late night in unfamiliar areas
- Use campus safe walk services
- Keep phone charged for emergencies
- Download SFMTA app for transit updates
