# Startup Founder Guide — San Francisco

## Accelerators & Investment Programs

### Tier 1 (Top Programs)

| Program | Investment | Equity | Duration | Focus |
|---------|-----------|--------|----------|-------|
| **Y Combinator** | $500K ($125K + $375K SAFE) | 7% | 3 months | Generalist, 200+ startups/batch |
| **Sequoia Arc** | $500K-$1M | Variable | Varies | Seed, technical teams |
| **a16z Speedrun** | $500K-$1M | 7-10% | Intensive | AI, gaming, cultural products |
| **HF0 Residency** | $1M SAFE | 5% | 12 weeks | Live-in, technical founders |
| **South Park Commons** | $400K + $600K follow-on | 7% | Fellowship | Pre-idea exploration |

### Tier 2 (Excellent Alternatives)

| Program | Investment | Equity | Focus |
|---------|-----------|--------|-------|
| **PearX** | $250K-$2M | ~10% | AI, SaaS, Climate |
| **Neo** | $600K SAFE | 1.5-5% | Young technical founders |
| **AI Grant** | $250K SAFE | - | AI-native products |
| **500 Global** | $150K | 6% | Global, post-MVP |
| **Techstars SF** | $120K ($20K + $100K note) | 6% | 13 weeks, mentor network |
| **Berkeley SkyDeck** | $200K | 5-7.5% | UC Berkeley affiliated |
| **Alchemist** | $25-36K | 5% | Enterprise/B2B |
| **HAX** | $250K | 9% | Hardware, deep tech |

## Venture Capital Landscape

### Tier 1 VCs (The Giants)

| Firm | AUM | Notable Investments |
|------|-----|---------------------|
| **Sequoia Capital** | $56B | Apple, Google, Airbnb, DoorDash |
| **Andreessen Horowitz** | $35B+ | Facebook, Airbnb, Coinbase |
| **Benchmark** | $3B+ | Uber, Snapchat, Twitter |
| **Greylock Partners** | $3.5B+ | LinkedIn, Figma, Discord |
| **Founders Fund** | $11B | SpaceX, Palantir, Stripe |

### Active at Seed/Series A

- Bessemer Venture Partners
- Index Ventures
- Lightspeed Venture Partners
- Accel
- Kleiner Perkins
- General Catalyst
- First Round Capital
- Khosla Ventures
- Redpoint Ventures

### Funding Statistics (2024-2025)

- **Bay Area VC:** ~$90B invested in 2024 (57% of US total)
- **Q1 2025:** $55B invested (~50% of global VC)
- **Recent mega-rounds:** OpenAI ($40B), xAI ($6B), Databricks ($10B)

## Coworking & Office Space

### Recommended Spaces

| Space | Location | Price Range | Best For |
|-------|----------|-------------|----------|
| **House of AI** | SoMa | Premium | AI startups |
| **Industrious** | 945 Market | $$$ | YC companies, professional |
| **Galvanize** | SoMa | $$ | 5 floors, rooftop |
| **SHACK15** | Ferry Building | $$$ | Views, networking |
| **AvantSpace** | Marina | $$ | Boutique, team suites |
| **WeWork** | Multiple | $$ | Flexible terms |

### Office Costs

- **Average rent:** $66/sq ft/year (2024)
- **Class A space:** $72/sq ft/year
- **1,000 sq ft office:** $5,400-7,500/month
- **Comparison:** LA ~40% cheaper, Austin ~60% cheaper

### Hacker Houses (Live + Work)

| House | Focus | Notes |
|-------|-------|-------|
| **HF0** | Technical founders | $1M investment included |
| **Treehouse Mansion** | Climate tech | Founder community |
| **Arcadia House** | General | Community focused |
| **The Residency** | General | 6 months, rent only |

## Networking with Investors

### Regular Events

- **AGI House** — Saturday hackathons, top-tier speakers
- **Founders Village Tech Weekend** — Direct VC access
- **Cerebral Valley** — AI event calendar (cerebralvalley.ai)
- **Luma (lu.ma)** — Community event platform

### Founder Communities

- **Founders Network** — Membership, mentoring
- **Founders Running Club** — Weekly runs, organic networking
- **On Deck** — Fellowship program
- **Product Hunt** — Launch community

### Key Events Calendar

| Event | Timing | Type |
|-------|--------|------|
| **YC Demo Day** | March, September | Batch presentations |
| **TechCrunch Disrupt** | October | Conference + Startup Battlefield |
| **SaaStr Annual** | May | B2B SaaS conference |
| **Startup Grind Global** | April | Founder conference |

## Startup Costs in SF

### Monthly Burn Estimates

| Stage | Team Size | Monthly Burn |
|-------|-----------|--------------|
| **Pre-seed** | 2 founders | $15-25K |
| **Seed** | 5-8 people | $80-150K |
| **Series A** | 15-25 people | $250-500K |

### Cost Breakdown (Pre-seed)

| Category | Monthly Cost |
|----------|-------------|
| Coworking (2 desks) | $800-1,500 |
| Founder salaries (minimal) | $0-10,000 |
| Cloud/infra | $200-2,000 |
| Legal | $500-1,000 |
| Software tools | $200-500 |
| **Total** | **$1,700-15,000** |

## Talent Recruitment

### Where to Find Engineers

- **Levels.fyi** — Salary benchmarks
- **LinkedIn** — Direct outreach
- **AngelList/Wellfound** — Startup-focused talent
- **YC Work at a Startup** — YC company job board
- **Hacker News Who's Hiring** — Monthly thread

### Competitive Compensation

| Role | Early Stage Equity | Cash |
|------|-------------------|------|
| Engineer #1-5 | 0.5-2% | $120-180K |
| Engineer #6-20 | 0.1-0.5% | $140-200K |
| First PM | 0.25-1% | $120-160K |

### Hiring Reality

- SF talent is expensive but accessible
- Remote hiring expands pool significantly
- Equity matters more at early stage
- AI talent commands 30-50% premium

## Should You Stay in SF?

### Reasons to Stay

- VC meetings are easier in person
- Talent density (especially AI)
- Serendipitous networking
- YC and accelerator access
- Tech culture/energy

### Reasons to Leave

- Cost savings (40-60% cheaper elsewhere)
- Remote-first culture is accepted
- Quality of life elsewhere
- Many VCs do Zoom anyway

### Common Alternatives

| City | Pros | Cons |
|------|------|------|
| **Austin** | 60% cheaper, growing tech | Less VC density |
| **NYC** | Finance/media VCs, talent | Still expensive |
| **Miami** | Tax benefits, growing | Newer ecosystem |
| **LA** | Creator economy, cheaper | Car-dependent |

### The Verdict

- **For first-time founders:** SF still has edge for networking/VCs
- **For experienced founders:** Can be anywhere, fly in for meetings
- **For AI startups:** SF is almost mandatory (talent density)
