# Safety Guide — San Francisco (Honest Assessment)

## Overview

SF has real safety concerns, but they're **concentrated in specific areas**. Most neighborhoods are quite safe. The key is knowing where to avoid.

## Areas to Avoid

### Tenderloin (Avoid Completely)
**Boundaries:** Market St (south), Geary St (north), Van Ness (west), Mason St (east)

- Open drug use and dealing
- Significant homelessness
- Property crime
- **Day:** Uncomfortable, keep moving
- **Night:** Avoid entirely
- **Exception:** A few good restaurants (Lers Ros, Brenda's) — Uber directly there

### Civic Center / Mid-Market
- Similar issues to Tenderloin
- Area around City Hall/UN Plaza
- BART Civic Center station can be rough
- Tech companies have offices here but street level is challenging

### Parts of SoMa (6th-8th Street Corridor)
- Drug activity, property crime
- Mixed area — research specific blocks
- Generally safer north of Market, sketchier south
- Car break-ins very common

### Hunters Point / Bayview
- Higher violent crime rates
- Environmental contamination concerns
- Far from central SF
- Gentrifying slowly but still rough in parts

## Safety by Activity

### Walking

| Time | Safe Areas | Caution Areas | Avoid |
|------|------------|---------------|-------|
| **Day** | Most neighborhoods | SoMa (vary by block) | Tenderloin |
| **Night** | Marina, Noe, Pac Heights, Castro | Mission (main streets OK) | Tenderloin, Civic Center |
| **Late night** | Uber recommended | Most areas | All above + empty streets |

### Public Transit
- **Generally safe** during day and commute hours
- **BART:** Civic Center and Powell stations can be sketchy
- **MUNI:** Usually fine, occasional issues
- **Late night:** More incidents, consider Uber
- **Keep valuables hidden:** Phone snatching does happen

### Driving
- **Car break-ins:** SF's biggest crime issue
- **Never leave anything visible** — even empty bags
- **Worst areas:** Fisherman's Wharf, Embarcadero, downtown, tourist spots
- **Tips:**
  - Leave glove box open (shows empty)
  - Empty trunk BEFORE arriving (thieves watch)
  - Use garages when possible

## Crime Statistics (Context)

### Property Crime
- **Very high** — one of highest rates in US
- Car break-ins, package theft, bike theft
- Downtown and tourist areas worst
- Residential areas generally better

### Violent Crime
- **Lower than perception** suggests
- Concentrated in specific neighborhoods
- Random violence against tourists is rare
- Most incidents involve people who know each other

### What's Improving (2024-2025)
- Some downtown areas recovering
- Increased police presence in tourist spots
- New businesses opening in some areas

### What's Still Problematic
- Open drug use in Tenderloin
- Car break-ins citywide
- Some retail closures due to theft

## Homelessness (What to Expect)

### Reality
- Very visible in certain areas
- Most homeless people are not dangerous
- Mental health and drug issues affect some
- Concentrated in: Tenderloin, Civic Center, parts of SoMa, some parks

### How to Handle
- **Generally:** Walk past, don't engage if uncomfortable
- **Aggressive panhandling:** Rare, just keep walking
- **Encampments:** Don't walk through, go around
- **If someone seems in crisis:** Call 311 or 911 if emergency

## Specific Safety Tips

### For Tourists
1. Don't leave anything in rental car — seriously, nothing
2. Stay aware in crowded tourist areas (pickpockets)
3. Avoid Tenderloin, even for "shortcut"
4. Keep phone secure on transit
5. Union Square is fine during day, more careful at night

### For New Residents
1. Research exact block before renting
2. Visit neighborhood at night before signing lease
3. Get renter's insurance (cheap, essential)
4. Secure bike properly (U-lock through frame)
5. Package theft is real — use Amazon locker or work address

### For Tech Workers
1. Don't flash expensive items
2. Laptop theft in cafes happens — stay alert
3. Late night Uber > walking from SoMa office
4. Company shuttles are safe

## Emergency Numbers

| Service | Number |
|---------|--------|
| **Emergency** | 911 |
| **Non-emergency police** | 415-553-0123 |
| **City services (311)** | 311 |
| **Poison control** | 1-800-222-1222 |

## Earthquake Preparedness

### The Basics
- SF sits on San Andreas fault — quakes will happen
- Buildings are generally well-constructed
- Most quakes are small and barely noticed

### What to Have
- 3 days water (1 gallon/person/day)
- Non-perishable food
- Flashlight, batteries
- First aid kit
- Cash (ATMs may not work)
- Phone charger (battery pack)

### During a Quake
- **Inside:** Drop, cover, hold on
- **Outside:** Move away from buildings, power lines
- **After:** Expect aftershocks, check for damage
- **Don't use elevators**

### Apps
- **SF72** — City's emergency preparedness
- **MyShake** — Earthquake early warning

## The Honest Summary

**SF is safe for most people in most places.** The problems are real but concentrated:

- **Tenderloin/Civic Center:** Avoid
- **Car break-ins:** Never leave anything visible, anywhere
- **Late night:** Use Uber in unfamiliar areas
- **Most neighborhoods:** Quite safe, normal city awareness

Don't let fear stop you from enjoying the city, but also don't be naive about the real issues in specific areas.
