# New Resident Guide — Moving to San Francisco

## First Month Timeline

**Weeks 1-2 (Before arrival):**
- Start apartment search online (market moves fast)
- Prepare documents: pay stubs, credit report, bank statements, ID
- Research neighborhoods matching your commute

**Week 2-3 (Upon arrival):**
- Stay in temporary housing (Airbnb, hotel)
- View apartments in person (essential in SF)
- Open bank account (need address, even temporary)
- Get local phone number

**Week 3-4 (Once housed):**
- Set up utilities (PG&E, Recology)
- Apply for SSN if needed
- DMV appointment for California license
- Register to vote

## Documentation Required

### Social Security Number (SSN)
- **Apply:** In person at nearest Social Security office
- **Bring:** Passport + visa/I-94 + proof of address
- **Timeline:** 2-4 weeks to receive card
- **Note:** Some services accept "ineligibility letter" if you don't qualify

### California Driver's License
- **Requirement:** Must obtain within 10 days of establishing residency
- **Documents needed:**
  - Passport + visa/I-94
  - SSN or ineligibility letter
  - CA residency proof: lease, utility bill, bank statement
- **Process:** Written test → Permit → Driving test → License
- **Tip:** Written test available in Spanish
- **Cost:** ~$38

### REAL ID vs Standard License
- REAL ID required for domestic flights from May 2025
- Requires additional documents (birth certificate, etc.)
- Standard license: driving only

## Finding an Apartment

### Timing
- Listings appear **max 30 days** before availability
- Best strategy: arrive **2-4 weeks early** to search in person
- **Winter (Nov-Feb):** Less competition, better prices
- **Summer:** Higher demand, higher prices

### Platforms (in order of reliability)
1. **Zillow** — Most complete, real-time alerts, fewer scams
2. **Craigslist** — More small landlord listings, BUT many scams
3. **Apartments.com** — Paid listings = fewer scams
4. **HotPads** — Good interface, owned by Zillow
5. **Facebook Groups** — Roommates and subleases
6. **Walking neighborhoods** — Many listings only have "For Rent" signs

### Application Documents (Have Ready)
- Proof of income: **3x monthly rent** (offer letter, pay stubs)
- Credit report or score
- Bank statements (3 months)
- References (previous landlords)
- Photo ID
- **Be ready to apply same day** — Competition is fierce

### Scam Warning Signs
- Below-market rent for area
- Request for wire transfer
- Can't view in person
- Listing "too good" for location
- Pressure to send money fast

## Cost of Living (Monthly)

### Single Person: $4,500-5,500/month

| Category | Monthly Cost |
|----------|-------------|
| Rent (1BR downtown) | $3,000-3,500 |
| Rent (1BR outer neighborhoods) | $2,400-2,800 |
| Utilities (PG&E) | $150-255 |
| Internet | $65-80 |
| Groceries | $400-800 |
| Transport (Clipper pass) | $81-98 |
| Phone | $50-70 |
| **Total (without extras)** | **$4,200-5,300** |

### Additional Costs
- Health insurance: $300-600 (if not employer-provided)
- Parking (if you have a car): $200-400/month
- Dining out: $15-25 per casual meal
- Coffee: $5-8 average, some up to $16

## Neighborhood Guide for New Residents

### Young Professionals (20s-30s)
| Neighborhood | Character | 1BR Rent | Notes |
|--------------|-----------|----------|-------|
| **Mission** | Vibrant, nightlife, food, art, sunny | $3,000-3,500 | Best weather in SF |
| **Marina** | Athletic, waterfront, bars | $3,200-3,800 | "Bro" culture |
| **Hayes Valley** | Trendy, boutiques, central | $3,200-4,000 | Walkable |
| **North Beach** | Historic, cafés, Italian | $2,800-3,400 | Hills |

### Families
| Neighborhood | Character | Notes |
|--------------|-----------|-------|
| **Noe Valley** | Family-friendly, parks, quiet | $4,500+/2BR |
| **Cole Valley** | Near Golden Gate Park | Spacious homes |
| **Bernal Heights** | Bohemian, strong community | More affordable |

### Budget-Conscious
| Neighborhood | Character | 1BR Rent |
|--------------|-----------|----------|
| **Outer Richmond** | Ocean-adjacent, multicultural | $2,200-2,800 |
| **Outer Sunset** | Foggy but peaceful, surfers | $2,100-2,600 |
| **Daly City** | Technically not SF, BART accessible | $1,800-2,300 |

### Avoid
- **Tenderloin** — High crime, drugs, homelessness
- **Civic Center** — Similar to Tenderloin
- **Parts of SoMa** — Property crime, drug activity
- **Hunters Point** — Crime + environmental issues

## Setting Up Utilities

### PG&E (Electricity & Gas)
- **Website:** pge.com
- **Cost:** $100-400/month depending on usage and heating
- **Tip:** Apply before move-in date

### SFPUC (Water)
- **Website:** sfpuc.gov
- **Usually:** Included in rent or billed through landlord

### Recology (Trash & Recycling)
- **Note:** Already configured by address, automatic
- **Bins:** Black (trash), blue (recycling), green (compost)

### Internet Options
- **Comcast/Xfinity:** Most common, $60-80/month
- **AT&T Fiber:** Where available, competitive
- **Webpass/Google Fiber:** Some buildings
- **Sonic:** Local alternative, good reputation

## Banking

### Recommended Banks
- **Chase** — Largest ATM network in SF
- **Wells Fargo** — Also extensive network
- **Bank of America** — Good for new residents
- **SF Federal Credit Union** — Local option, better rates

### Opening an Account
- Need: Government ID + proof of address (even temporary)
- Can use hotel/Airbnb address initially
- Chase and BoA are most flexible for new residents

## Common Mistakes to Avoid

1. **Renting sight unseen** — Always view in person
2. **Underestimating costs** — Budget $5K+/month to be safe
3. **Bringing a car immediately** — Transit is often better
4. **Not checking Tenderloin proximity** — Many "downtown" listings border it
5. **Waiting on apartment applications** — Submit same day or lose it
6. **Expecting warm summers** — Bring layers, fog is real
7. **Skipping renter's insurance** — Cheap and essential (~$15/month)
