# Local Resident Guide — San Francisco Daily Life

## Municipal Services

### DMV (Department of Motor Vehicles)
- **SF Office:** 1377 Fell St, San Francisco
- **Appointments:** dmv.ca.gov/portal/appointments
- **Services:** REAL ID, license renewal, vehicle registration
- **Tip:** Book 2-3 weeks ahead, appointments fill fast
- **REAL ID:** Required for domestic flights from May 2025

### SF311 — Report City Problems
- **App:** SF311 (iOS/Android) or call 311
- **Report:** Potholes, graffiti, trash, fallen trees, encampments
- **Alternative app:** Solve SF (community-driven, faster)
- **Tip:** Include photo + GPS for faster response

### Permit Center
- **Location:** 49 South Van Ness Ave, 2nd Floor
- **Phone:** (415) 831-5500
- **Types:** Construction, events, business, parklets
- **Website:** sf.gov/topic-permitting

## Utilities

| Service | Provider | Portal | Monthly Cost |
|---------|----------|--------|--------------|
| Electricity/Gas | PG&E | pge.com | $100-400 |
| Water/Sewer | SFPUC | sfpuc.gov | $50-150 |
| Trash/Recycling | Recology | recology.com | $80-130 |

### Notes
- **SFPUC Discount:** 25-40% off for low-income households
- **Recology:** Auto-configured by address, no activation needed
- **PG&E:** Can take 1-2 weeks to set up, apply before move-in

## Taxes

### California State Income Tax
- **Brackets:** 1% to 12.3% (progressive, 9 brackets)
- **Top bracket:** 12.3% for income >$677,275 (single)
- **Mental Health Surcharge:** +1% for income >$1M

### San Francisco Specific
- **Local income tax:** 0% (no city income tax)
- **Sales tax:** 8.625% (state + county + district)
- **Property tax (effective):** ~0.65% of assessed value
- **Example:** $1.35M home = ~$8,775/year property tax

### Key Dates
- **Federal + State deadline:** April 15
- **CA extension:** Automatic 6 months (but pay estimated tax)
- **Website:** ftb.ca.gov (Franchise Tax Board)

## Voting & Civic Participation

### Voter Registration
- **Online:** registertovote.ca.gov
- **In person:** City Hall, Room 48 (until Election Day)
- **Requirements:** 18+, US citizen, CA resident

### Ways to Vote
- **Vote-by-mail:** Automatic for all registered voters
- **In person:** City Hall Voting Center or local polling places
- **Track ballot:** WheresMyBallot.sos.ca.gov

### Department of Elections
- **Location:** 1 Dr. Carlton B. Goodlett Place, City Hall Room 48
- **Website:** sfelections.sfgov.org
- **Languages:** English, Spanish, Chinese, Filipino, more

### Local Participation
- **Board of Supervisors:** 11 districts, public meetings
- **SF Ballot Measures:** Many local propositions each election
- **Planning Commission:** Comment on development projects

## Shopping — Local Favorites

### Budget-Friendly Groceries

| Store | Specialty | Locations |
|-------|-----------|-----------|
| **Trader Joe's** | Own-brand products, cheap wine | Multiple |
| **Grocery Outlet** | Surplus discounts | Multiple |
| **Lucky** | Competitive prices | Various |
| **Smart & Final** | Bulk buying | Various |

### Asian Markets (Best Produce Prices)
- **99 Ranch** — Daly City (near SF)
- **Sunset Supermarket** — Sunset/Richmond
- **May Wah** — Richmond District
- **H-Mart** — Premium quality, higher prices
- **Pacific Supermarket** — Competitive

### Premium/Specialty
- **Rainbow Grocery** (Mission) — Co-op, best bulk section in SF
- **Whole Foods** — Multiple, expensive but quality
- **Gus's Community Market** — Local, has Philz Coffee inside
- **Other Avenues** (Sunset) — Co-op, good bulk

### Farmers Markets
- **Ferry Building** — Saturdays, largest
- **Fort Mason** — Sundays
- **Clement Street** — Sundays, more local
- **Castro** — Wednesdays

### Money-Saving Apps
- **Too Good To Go** — $6 food rescue bags (Whole Foods, bakeries)
- **Flashfood** — Deals at Lucky stores
- **Instacart** — Price compare delivery

## Local Services

### Recommended Providers

| Service | Provider | Notes |
|---------|----------|-------|
| **Internet** | Sonic (local), Comcast, AT&T | Sonic has best reputation |
| **Phone** | Mint Mobile, Visible | Budget options work fine |
| **Laundry** | Rinse | Pickup/delivery |
| **Cleaning** | Handy, Taskrabbit | On-demand |
| **Handyman** | Taskrabbit | Reliable |

### Finding Contractors
- **Yelp** — Reviews for plumbers, electricians
- **Nextdoor** — Neighborhood recommendations
- **Taskrabbit** — Smaller jobs
- **Thumbtack** — Compare quotes

## Weekend Activities (What Locals Actually Do)

### Free/Cheap
- **Dolores Park** — Sunny days, bring blanket
- **Golden Gate Park** — Picnic, bike, museums (free days)
- **Ocean Beach** — Bonfires (cold, bring layers)
- **Hiking:** Lands End, Twin Peaks, Bernal Hill
- **Ferry Building** — Saturday farmers market

### Cultural
- **De Young Museum** — Free first Tuesday
- **SFMOMA** — Free first Thursday (with reservation)
- **Free concerts** — Hardly Strictly Bluegrass (October)
- **Movie nights:** Fort Mason, Dolores Park (summer)

### Sports
- **Giants games** — Oracle Park (cheap tickets available)
- **Warriors** — Chase Center (expensive)
- **Pickup basketball** — Mission Playground, Potrero
- **Running:** Marina Green, Crissy Field, Embarcadero

## Current City Issues (Honest Assessment)

### Homelessness
- Concentrated in Tenderloin, parts of SoMa, Civic Center
- Visible but generally not dangerous
- City services: 311 for encampment reports

### Car Break-Ins
- **Never leave anything visible** — Even empty bags get windows smashed
- Worst areas: tourist spots, Embarcadero, downtown
- Consider garages over street parking

### Drug Activity
- Open drug use in Tenderloin, Civic Center
- Less visible in residential neighborhoods
- Avoid these areas late at night

### What's Getting Better
- Some downtown streets recovering
- New businesses opening in Mission Bay
- AI industry bringing energy back

### What's Still Hard
- Office vacancy still high
- Retail closures in some areas
- High cost of living unchanged
