# Cost of Living — San Francisco

## Overview

SF is one of the most expensive cities in the US. A "$150K salary here equals ~$80K elsewhere."

### Key Stats
- **#2 most expensive US city** (after NYC)
- **155% higher housing costs** vs national average
- **52% higher overall** vs national average

## Monthly Budget Breakdown

### Single Person: $4,500 - $6,500/month

| Category | Range | Notes |
|----------|-------|-------|
| **Rent (1BR downtown)** | $3,000 - 3,500 | SoMa, Mission, Hayes |
| **Rent (1BR outer)** | $2,400 - 2,800 | Sunset, Richmond |
| **Utilities** | $150 - 255 | PG&E + internet |
| **Groceries** | $400 - 800 | Depends on eating out |
| **Transport** | $81 - 200 | MUNI pass + occasional Uber |
| **Phone** | $50 - 70 | |
| **Health insurance** | $0 - 600 | Employer-provided to self-pay |
| **Entertainment** | $200 - 500 | Dining, drinks, activities |
| **TOTAL** | **$4,280 - 6,525** | |

### Couple (2 People): $6,000 - $8,500/month

| Category | Range |
|----------|-------|
| **Rent (1BR)** | $3,000 - 3,500 |
| **Rent (2BR)** | $3,800 - 4,500 |
| **Utilities** | $180 - 300 |
| **Groceries** | $600 - 1,000 |
| **Transport** | $162 - 350 |
| **Other** | Varies |

### Family of 4: $10,000 - $15,000+/month

| Category | Range |
|----------|-------|
| **Rent (3BR)** | $5,000 - 7,000+ |
| **Childcare** | $2,000 - 4,000 |
| **Groceries** | $1,000 - 1,500 |
| **Other** | Varies significantly |

## Housing Costs (2024-2025)

### Rental Prices by Unit Size

| Type | Downtown/Central | Outer Neighborhoods |
|------|-----------------|-------------------|
| **Studio** | $2,200 - 2,800 | $1,800 - 2,200 |
| **1BR** | $3,000 - 3,500 | $2,400 - 2,800 |
| **2BR** | $3,800 - 4,500 | $3,000 - 3,500 |
| **3BR** | $5,000 - 7,000 | $4,000 - 5,000 |

### By Neighborhood

| Neighborhood | 1BR Range | Notes |
|--------------|-----------|-------|
| **Pacific Heights** | $4,000 - 5,000+ | Most expensive |
| **Marina** | $3,200 - 3,800 | |
| **Hayes Valley** | $3,200 - 4,000 | |
| **Mission** | $3,000 - 3,500 | Sunny premium |
| **Castro** | $2,800 - 3,400 | |
| **North Beach** | $2,800 - 3,400 | |
| **SoMa** | $2,600 - 3,500 | Varies by block |
| **Outer Richmond** | $2,200 - 2,800 | |
| **Outer Sunset** | $2,100 - 2,600 | Cheapest in SF |
| **Daly City** | $1,800 - 2,300 | Outside SF, BART access |

### Buying Property

| Type | Median Price | $/sq ft |
|------|-------------|---------|
| **Condo/TIC** | $1.0 - 1.5M | $900 - 1,200 |
| **Single Family** | $1.5 - 2.5M+ | $1,000 - 1,500 |
| **Property tax** | ~0.65% | Of assessed value |

## Utilities

| Service | Monthly Cost | Notes |
|---------|-------------|-------|
| **Electricity + Gas (PG&E)** | $100 - 400 | Heating = higher |
| **Water (SFPUC)** | $50 - 150 | Often included in rent |
| **Trash (Recology)** | $80 - 130 | Sometimes included |
| **Internet** | $60 - 80 | Comcast, Sonic, AT&T |
| **Cell phone** | $50 - 70 | Standard plan |

## Transportation

| Option | Monthly Cost |
|--------|-------------|
| **MUNI pass** | ~$81 |
| **MUNI + BART pass** | ~$98 |
| **Uber/Lyft (moderate use)** | $100 - 300 |
| **Parking (garage)** | $200 - 600 |
| **Car payment + insurance** | $400 - 800 |

**Total car ownership:** $600 - 1,400/month (payment, insurance, gas, parking, maintenance)

**Tip:** Most SF residents don't own cars

## Food & Dining

### Groceries (Monthly)

| Store Type | Budget |
|------------|--------|
| **Budget (TJ's, Grocery Outlet)** | $300 - 400 |
| **Standard (Safeway, Lucky)** | $400 - 600 |
| **Premium (Whole Foods, Bi-Rite)** | $600 - 1,000 |

### Dining Out

| Type | Per Person |
|------|------------|
| **Cheap eats** | $10 - 15 |
| **Casual restaurant** | $20 - 40 |
| **Nice dinner** | $50 - 100 |
| **Fine dining** | $150 - 300+ |
| **Coffee** | $5 - 8 |
| **Beer/drink** | $8 - 15 |

## Health Insurance

### If Employer-Provided
- Usually covered or subsidized
- Family plans: Employer often covers portion

### If Self-Employed/Individual

| Option | Monthly Cost |
|--------|-------------|
| **Covered California (Silver)** | $400 - 800 |
| **Kaiser (HMO)** | $350 - 600 |
| **Catastrophic (young adult)** | $150 - 300 |

### Healthcare Costs
- Doctor visit (with insurance): $20 - 50 copay
- ER visit: $150 - 500 copay
- Prescriptions: Varies widely

## Childcare

| Type | Monthly Cost |
|------|-------------|
| **Daycare (full-time)** | $2,000 - 3,500 |
| **Nanny (full-time)** | $4,000 - 6,000+ |
| **Preschool** | $1,500 - 3,000 |
| **After-school care** | $500 - 1,000 |

**Note:** Childcare waitlists can be 6-12+ months

## Salary Needed to Live Comfortably

### Single Person

| Lifestyle | Gross Annual | After Tax | Notes |
|-----------|-------------|-----------|-------|
| **Survive** | $80K | ~$60K | Roommates, budget tight |
| **Comfortable** | $120K | ~$85K | Own 1BR, save a bit |
| **Very comfortable** | $180K+ | ~$120K | Nice apartment, savings |

### Couple (No Kids)

| Lifestyle | Gross Annual Combined |
|-----------|----------------------|
| **Comfortable** | $180K |
| **Very comfortable** | $250K+ |

### Family of 4

| Lifestyle | Gross Annual |
|-----------|-------------|
| **Comfortable** | $300K+ |
| **Very comfortable** | $400K+ |

## Money-Saving Tips

### Housing
- **Roommates:** Common even for professionals
- **Outer neighborhoods:** 20-30% cheaper
- **Off-season search:** November-February
- **Daly City/Oakland:** Cheaper, BART accessible

### Food
- **Trader Joe's:** Best value groceries
- **Asian markets:** Cheapest produce
- **Cook at home:** $15 meal out = $5 at home
- **Too Good To Go:** $6 bags from restaurants

### Transport
- **Skip the car:** Save $600-1,400/month
- **Clipper card:** Small savings add up
- **Bike:** Free after initial cost

### Entertainment
- **Free museum days:** First Tuesday/Thursday
- **Hiking:** Free, world-class
- **Dolores Park:** Free, great people watching

## Comparison to Other Cities

| City | vs SF Cost |
|------|-----------|
| **NYC** | Similar (slightly less) |
| **Seattle** | 20% less |
| **LA** | 25% less |
| **Austin** | 40% less |
| **Denver** | 35% less |
| **National Average** | 52% less |
