# Weather & Climate Guide — San Francisco

## The Famous Microclimate System

SF has **dramatically different weather** depending on neighborhood. The city's unique geography (hills, bay, ocean) creates distinct microclimates within miles of each other.

### How It Works
- **Ocean fog** rolls in from the west
- **Hills** block fog from reaching eastern neighborhoods
- **The Bay** moderates temperatures
- Result: 20°F+ difference between neighborhoods

## Weather by Neighborhood

| Neighborhood | Fog Level | Avg Temp | Notes |
|--------------|-----------|----------|-------|
| **Mission** | Low | Warmest | "Mission micro-climate" is real |
| **Castro** | Low | Warm | Protected by hills |
| **Noe Valley** | Low | Warm | Sunny valley |
| **Potrero Hill** | Low | Warm | South-facing slope |
| **Downtown/SoMa** | Medium | Moderate | Variable |
| **Marina** | Medium | Moderate | Can be windy |
| **North Beach** | Medium | Moderate | Pleasant |
| **Richmond** | High | Cool | "The fogbelt" |
| **Sunset** | Very High | Coolest | Ocean-adjacent fog |
| **Presidio** | Variable | Cool | Near Golden Gate = foggy |

### The Rule
- **East/Central = warmer, sunnier** (Mission, Castro, downtown)
- **West/Ocean = cooler, foggier** (Sunset, Richmond, Ocean Beach)

## Monthly Weather Breakdown

| Month | Avg High | Avg Low | Rain Days | Notes |
|-------|----------|---------|-----------|-------|
| **Jan** | 56°F/13°C | 46°F/8°C | 10 | Rainy season |
| **Feb** | 59°F/15°C | 48°F/9°C | 9 | Rainy season |
| **Mar** | 61°F/16°C | 49°F/9°C | 8 | Transitioning |
| **Apr** | 63°F/17°C | 50°F/10°C | 4 | Pleasant |
| **May** | 64°F/18°C | 51°F/11°C | 2 | Nice, some fog |
| **Jun** | 66°F/19°C | 53°F/12°C | 1 | FOG BEGINS |
| **Jul** | 66°F/19°C | 54°F/12°C | 0 | Foggy, cool |
| **Aug** | 67°F/19°C | 55°F/13°C | 0 | "Fogust" |
| **Sep** | 70°F/21°C | 55°F/13°C | 1 | **WARMEST** |
| **Oct** | 69°F/21°C | 54°F/12°C | 2 | **Indian summer** |
| **Nov** | 62°F/17°C | 50°F/10°C | 6 | Cooling, rain returns |
| **Dec** | 56°F/13°C | 46°F/8°C | 9 | Rainy season |

## Best Time to Visit

### September - October (Warmest)
- **Pros:** Warmest weather, least fog, sunny
- **Cons:** Wildfire smoke possible (some years)
- **Events:** Fleet Week (Oct), Hardly Strictly Bluegrass

### April - May (Spring)
- **Pros:** Pleasant, not crowded, less rain
- **Cons:** Some fog starting
- **Events:** Cherry blossoms, baseball season starts

### November - December (Winter)
- **Pros:** Holiday lights, fewer tourists, lower prices
- **Cons:** Rainy, shorter days
- **Events:** Holiday markets, tree lighting

### June - August (Summer) — SURPRISE!
- **Warning:** This is NOT warm summer weather
- **Reality:** Heavy fog, cool temperatures, often in 60s
- **"Fogust":** August is often the foggiest month
- Mark Twain (maybe): "The coldest winter I ever spent was a summer in San Francisco"

## What to Pack

### Essential (Any Time)
- **Layers** — Temperature swings 20°F in one day
- **Light jacket or sweater** — Even in "summer"
- **Comfortable walking shoes** — Hills are real
- **Wind layer** — Especially near water

### By Season

| Season | Add These |
|--------|-----------|
| **Winter** | Rain jacket, umbrella, warmer layers |
| **Spring** | Light rain layer, sun protection |
| **Summer** | Warm layers (yes, really), fog-appropriate clothes |
| **Fall** | Light layers, sun protection |

### Pro Tip: The Transition
- Morning: Foggy, cool → wear layers
- Midday: Fog burns off, warms up → remove layers
- Evening: Fog returns, cools down → add layers back

## Karl the Fog

SF personified its fog as "Karl" (with his own Twitter account).

### Fog Patterns
- **Marine layer** rolls in from ocean
- Typically arrives late afternoon/evening
- Burns off by mid-morning
- **Summer = more fog** (counterintuitive)

### Where Fog Goes
- Golden Gate is "fog highway" into city
- Sunset/Richmond: First hit, last to clear
- Mission/Castro: Often fog-free even when elsewhere is socked in

## Air Quality Concerns

### Wildfire Season (Aug - Nov)
- Wildfires elsewhere can bring smoke to SF
- Check AirNow.gov for current conditions
- N95 masks help if smoke is bad
- Usually only a few bad days per year

### Regular Air Quality
- Generally good to excellent
- Better than most major US cities
- Ocean breeze helps clear air

## Weather Apps

| App | Best For |
|-----|----------|
| **Weather Underground** | Hyperlocal conditions |
| **Dark Sky (Apple)** | Minute-by-minute precipitation |
| **Windy** | Wind patterns, fog visualization |
| **AirNow** | Air quality, smoke |
| **PurpleAir** | Hyperlocal air quality sensors |

## Practical Implications

### For Activities
- **Morning hikes:** Expect fog, bring layers
- **Beach:** Bring jacket, rarely hot enough for swimwear
- **Picnics:** Mission Dolores = sunny, Ocean Beach = cold
- **Photos of Golden Gate:** Morning fog often obscures it

### For Events
- **Outdoor concerts:** Dress warmly, even in summer
- **Giants games:** Cold at night, bring jacket
- **Outside Lands (Aug):** Notoriously cold and foggy

### For Living
- **AC:** Almost nobody has it (rarely needed)
- **Heat:** Essential in some neighborhoods
- **Sunny apartment:** Premium, especially in foggy areas
- **South-facing windows:** Big deal in SF
