#!/bin/bash
# Sales Rhythm Tracker — Pipeline Health Check
# Reads pipeline and outputs health analysis with recommendations
# Best used on Fridays or when user asks "pipeline review"

SALES_DIR="${HOME}/.openclaw/workspace/sales"
PIPELINE="$SALES_DIR/pipeline.md"
ACTIVITY_LOG="$SALES_DIR/activity-log.md"
TODAY=$(date +"%Y-%m-%d")

if [ ! -f "$PIPELINE" ]; then
  echo "❌ Pipeline not initialized. Run: init-pipeline.sh first"
  exit 1
fi

echo "============================================"
echo "🏥 PIPELINE HEALTH REVIEW — ${TODAY}"
echo "============================================"
echo ""
echo "📋 FULL PIPELINE:"
cat "$PIPELINE"
echo ""
echo "---"
echo ""
echo "📋 RECENT ACTIVITY (last 14 days):"
cat "$ACTIVITY_LOG" | tail -100
echo ""
echo "---"
echo ""
echo "💡 AGENT INSTRUCTIONS — Perform full health analysis:"
echo ""
echo "STEP 1 — TEMPERATURE CHECK"
echo "For each active lead, calculate days since Last Contact."
echo "  • >14 days no contact = 🔴 Red (cooling fast)"
echo "  • 8-14 days = 🟡 Yellow (needs attention)"
echo "  • <7 days = 🟢 Green (healthy rhythm)"
echo ""
echo "STEP 2 — STAGE VELOCITY ANALYSIS"
echo "Flag any lead stuck in the same stage past healthy duration:"
echo "  • connected > 3 days without moving = flag"
echo "  • qualified > 7 days = flag"
echo "  • proposal > 10 days = flag"
echo "  • negotiation > 14 days = flag"
echo "  • closing > 5 days = URGENT flag"
echo ""
echo "STEP 3 — BOILING WATER RISK ASSESSMENT"
echo "Identify leads where momentum is at risk of cooling completely."
echo "These need intervention THIS WEEK or should be classified as lost."
echo ""
echo "STEP 4 — FLIP DECISIONS (翻牌)"
echo "Identify leads that should be cut from active pipeline:"
echo "  • No response after 3+ contacts"
echo "  • Confirmed no budget"
echo "  • Stuck >21 days with no movement"
echo "Moving these to 'inactive' clears mental bandwidth for live opportunities."
echo ""
echo "STEP 5 — PIPELINE METRICS SUMMARY"
echo "Calculate and report:"
echo "  • Total active leads"
echo "  • Leads per stage (show as mini funnel)"
echo "  • Overall pipeline conversion rate estimate"
echo "  • Expected closes in next 2 weeks"
echo "  • Red flags count"
echo ""
echo "STEP 6 — NEXT WEEK RECOMMENDATIONS"
echo "Based on the analysis:"
echo "  • What's the sprint phase next week? (Seed/Flip/Harvest/Reset)"
echo "  • Which 3 leads are the top priorities?"
echo "  • Which leads should be cut?"
echo "  • How many new leads need to be added to maintain healthy pipeline?"
echo ""
echo "Format as the Pipeline Health Report structure."
echo "End with one clear directive: the single most important action for Monday morning."
