---
name: sales-manager
description: 销售团队全流程管理技能。适用于：1) 设定和跟踪销售目标（日/周/月/季度/年） 2) 过程管理（每日打卡、客户跟进监督、复盘） 3) 提成与激励方案设计（利润导向+合伙人机制） 4) 招聘流程管理 5) 离职交接管理。侧重目标管理和过程管理。
---

# 销售管理技能

## 概述

本技能提供销售团队全流程管理能力，重点覆盖**目标管理**、**过程管理**和**激励模式设计**三大核心模块，兼顾招聘、离职交接、合伙人机制等功能。

## 核心功能

### 1. 目标管理（重点）

#### 1.1 目标设定

- **分层设定**：核心销售、潜力销售、新销售，不同层级不同目标
- **时间颗粒度**：年度→季度→月度→每周→每日，逐层拆解
- **量化指标**：开单数量、跟进客户数、拓展新客户数、销售额

**参考标准（可调整）：**

| 层级 | 月开单 | 跟进客户 | 新客户拓展 |
|------|--------|----------|------------|
| 核心销售 | 5-6单 | 30个 | 15个 |
| 潜力销售 | 3-4单 | 25个 | 10个 |
| 新销售 | 1-2单 | 20个 | 8个 |

#### 1.2 目标跟踪

- 每日记录目标完成进度
- 每周复盘目标达成情况
- 每月总结并调整下月目标

### 2. 过程管理（重点）

#### 2.1 每日打卡

销售每日需报备：
- 跟进客户数量及详情
- 拓展新客户数量
- 开单情况
- 遇到的困难

#### 2.2 客户跟进监督

- 要求销售记录每次跟进内容（客户信息、跟进时间、需求、下次跟进时间）
- 定期抽查跟进记录
- 确保销售真实跟进客户，而非摸鱼

#### 2.3 复盘机制

- **日复盘**：每日夕会总结当天工作
- **周复盘**：每周分析目标完成情况，优化工作方法
- **月复盘**：总结月度表现，奖惩兑现

### 3. 激励模式设计（重点）

⚠️ **警惕底薪+提成模式的3大危害：**

1. **低价抢单**：销售为冲业绩压低报价，利润被吞噬
2. **坏账风险**：销售只管签单不管回款，风险全甩给公司
3. **透支品牌**：一锤子买卖，牺牲长期客户价值
4. **培养对手**：销售翅膀硬了会单干，带走客户和员工

**解决方案：从"销售额导向"转向"利润导向"，从"雇佣"转向"合伙"**

#### 方案一：基础版 — 利润提成制

| 毛利润区间 | 提成比例 |
|-----------|----------|
| 0-5万元 | 8% |
| 5-10万元 | 12% |
| 10-20万元 | 15% |
| 20万元以上 | 20% |

- **亏损订单**：无提成，并按亏损额5%-10%扣罚（上限不超过当月底薪30%）

#### 方案二：进阶版 — 利润+回款双挂钩

- 订单成交后，发放提成40%
- 客户全款到账后，发放剩余60%
- **提前回款奖励**：额外奖励利润2%-5%
- **坏账惩罚**：超过6个月未回款，退还已发提成，并扣罚坏账金额3%-5%

#### 方案三：高阶版 — 四维激励体系

| 维度 | 激励内容 |
|------|----------|
| 利润提成 | 按毛利润阶梯提成 |
| 回款奖励 | 提前回款奖励、全款到账奖励 |
| 客户复购 | 老客户复购，提成上浮3%-5% |
| 客户满意度 | 季度满意度≥90分奖2000元 |

### 4. 合伙人机制（进阶）

⚠️ **核心问题：传统"底薪+提成"可能培养竞争对手**

员工利用公司平台积累经验，时机成熟可能单干，带走客户和员工。

#### 长期激励体系

| 周期 | 模式 | 适用对象 | 激励内容 |
|------|------|---------|---------|
| **短期** | 绩效激励 | 一线销售 | 多维考核：业绩+利润+效率 |
| **中期** | 增量分红 | 销售主管 | 超额利润的20-30%作为团队奖金 |
| **长期** | 利润分享 | 核心销售/合伙人 | 分红权，无所有权，离职失效 |

#### 合伙人实施要点

**短期激励（月度/季度）：**
- 设定多维度考核指标：业绩额+毛利润+回款率+客户开发
- 超过平衡点即有奖励，上不封顶

**中期激励（年度）：**
- 设定年度利润目标
- 超出部分拿出20-30%作为部门奖金池
- 团队负责人带领冲击目标

**长期激励：**
- 定人定股：明确授予对象和数量
- 定价：参考公司净资产或估值
- 约定分红和退出机制

#### 合伙人准入条件（参考）

- 入职满1年
- 年业绩达到一定标准
- 认同公司文化
- 签合伙人协议

#### 合伙人权益

- 享受利润分红
- 参与公司重大决策
- 获得公司发展的长期收益
- 离职后权利自动失效

**落地关键细节：**

1. **利润核算透明化** — 公开公式，让销售自己能算账
2. **设置过渡期** — 3-6个月双轨制，避免收入断崖式下降
3. **差异化激励** — 新销售侧重开单数，老销售侧重利润和复购

### 5. 招聘流程

#### 5.1 筛选流程（三步筛选）

1. **简历筛选**：重点筛选有销售经验、责任心强、能抗压的候选人
2. **面试筛选**：考察责任心、积极性、抗压能力、沟通能力
3. **试用期筛选**：1-2个月试用期，制定明确目标，达标转正

#### 5.2 培训流程（三阶段）

1. **第1周**：产品知识培训
2. **第2周**：销售技能培训（话术、跟进技巧、应对拒绝）
3. **长期**：心态培训+实战带教

### 6. 离职交接

- 提前通知期（通常1-2周）
- 客户资源交接清单
- 工作内容交接记录
- 提成和工资结算

## 使用场景

### 场景1：设定月度销售目标

用户：帮我给销售团队设定本月目标

回复：
1. 了解团队规模和人员层级
2. 根据层级制定差异化目标
3. 拆解到每周、每日
4. 建立跟踪机制

### 场景2：设计激励方案

用户：销售只知道冲业绩不管利润，怎么设计激励？

回复：
1. 分析当前底薪+提成模式的危害
2. 推荐利润提成制或四维激励体系
3. 说明利润核算透明化方法
4. 建议设置过渡期

### 场景3：设计合伙人机制

用户：我想让销售成为公司合伙人，怎么做？

回复：
1. 解释"雇佣 vs 合伙"的区别
2. 介绍三级火箭：KSF→IBP→虚拟股权
3. 给出合伙人准入条件和权益
4. 说明实施要点

### 场景4：计算利润提成

用户：本月签了一单销售额XX万，毛利润XX万，按利润提成怎么算？

回复：
- 根据毛利润区间对照提成比例表计算

### 场景5：销售过程监督

用户：销售最近跟进客户不积极

回复：
1. 检查客户跟进记录
2. 了解不积极的原因
3. 制定改进措施
4. 加强监督频率

### 场景6：招聘筛选

用户：帮我面试一个销售候选人

回复：
1. 提问考察责任心、积极性、抗压能力
2. 询问过往销售经历和业绩
3. 了解离职原因和求职动机
4. 给出是否通过的建议

## 配套工具

本技能可配合飞书多维表格使用，实现：
- 目标看板
- 客户跟进记录
- 利润提成计算表
- 招聘进度跟踪

如需创建对应的飞书表格，请告知具体需求。
