---
name: sales-funnel-design
description: Design and optimize a sales funnel for a solopreneur business. Use when mapping how customers move from first awareness to paying customer, identifying where leads drop off, building or improving any stage of the funnel (awareness, consideration, decision, retention), or optimizing conversion rates. Covers funnel architecture, stage-by-stage tactics, conversion benchmarks, solopreneur-specific funnel models (self-serve vs. high-touch), and funnel analytics. Trigger on "sales funnel", "design my funnel", "optimize my funnel", "conversion funnel", "why aren't people buying", "lead to customer", "funnel stages", "improve conversions".
---

# Sales Funnel Design

## Overview
A sales funnel is the complete path a stranger takes to become a paying customer — and then a loyal one. For solopreneurs, funnel design is critical because you cannot afford to lose people at any stage. Every dropped lead is revenue you'll never recover. This playbook builds your funnel from scratch, maps the right tactics to each stage, and gives you the metrics to know exactly where to focus.

---

## Step 1: Choose Your Funnel Model

Solopreneurs typically operate one of two funnel models. Pick the one that matches your business, then customize it.

### Model A: Self-Serve Funnel (Product-Led)
Customer discovers, evaluates, and buys with minimal human interaction. Best for: SaaS products, digital products, tools under ~$100/month.

```
AWARENESS → CONSIDERATION → DECISION → PURCHASE → ACTIVATION → RETENTION
   (find you)   (evaluate)    (decide)   (pay)     (get value)   (stay)
```

### Model B: High-Touch Funnel (Sales-Led)
Customer discovers you, then has a conversation before buying. Best for: consulting, services, enterprise tools, products over ~$200/month or custom pricing.

```
AWARENESS → CONSIDERATION → DISCOVERY CALL → PROPOSAL → DECISION → CLOSE → ONBOARDING → RETENTION
   (find you)   (research)     (talk to you)   (your pitch)  (think)  (pay)   (get started)  (stay)
```

**Most solopreneurs start with Model B and evolve toward Model A as the product matures and pricing drops.** You can run both simultaneously for different customer segments.

---

## Step 2: Map Each Funnel Stage

For each stage, define three things: what the customer is thinking, what YOU do at this stage, and what moves them to the next stage.

### Stage 1: Awareness
**Customer thinking:** "I have a problem. I'm looking for solutions. I don't know you exist yet."

**Your job:** Be findable where they're already looking.

**Tactics:**
- SEO content targeting the problem keywords they search for
- Social media posts about the problem (not your product — the problem)
- Paid ads targeting the exact audience with the exact pain
- Word-of-mouth: make existing customers want to talk about you
- Community presence: be helpful in forums/Slack/Reddit where your audience hangs out

**What moves them forward:** They click on something. They land on your site or content. They recognize you might have what they need.

### Stage 2: Consideration
**Customer thinking:** "This might solve my problem. Let me learn more. Is this legit? Is it worth it?"

**Your job:** Build trust and demonstrate value clearly.

**Tactics:**
- Website that clearly explains the problem, your solution, and proof it works
- Free content that shows expertise (blog posts, guides, tutorials, videos)
- Social proof: reviews, case studies, customer logos, testimonials
- Free trial, demo, or freemium tier that lets them experience the product

**What moves them forward:** They believe you can solve their problem AND that you're trustworthy enough to pay.

### Stage 3: Decision (Self-Serve) / Discovery Call (High-Touch)

**Self-serve:** Customer is ready to buy but needs final confidence.
- Clear pricing page with no surprises
- FAQ that addresses every common objection
- Money-back guarantee or risk reversal
- Simple, low-friction checkout

**High-touch:** Customer wants to talk before committing.
- Easy scheduling (Calendly or equivalent — one click, no email back-and-forth)
- Discovery call that listens first, then presents a tailored solution
- Follow-up within 24 hours with a summary and next steps

### Stage 4: Purchase / Close
**Customer thinking:** "I'm buying. Make it easy."

**Your job:** Remove every possible friction point.

- One-click or minimal-step checkout
- Multiple payment options (card, annual vs. monthly)
- Instant confirmation with clear next steps
- For high-touch: proposal → signing → payment in as few steps as possible

### Stage 5: Activation
**Customer thinking:** "I just paid. Show me this is worth it. Fast."

**Your job:** Get them to their first "aha moment" as quickly as possible. This is the single most important stage for retention.

- Onboarding flow that guides them to first value in under 10 minutes
- A "quick win" — something they can accomplish immediately that proves the product works
- Clear next steps after the quick win

### Stage 6: Retention
**Customer thinking:** "Am I still getting value? Should I keep paying?"

**Your job:** Continuously deliver value and remind them of it.

- Regular check-ins (automated or personal, depending on price point)
- In-product nudges showing usage stats or value delivered ("You saved 3 hours this week")
- Upsell opportunities when they've outgrown their current tier
- Community or support access that creates belonging

---

## Step 3: Define Conversion Metrics at Every Stage

You cannot improve what you don't measure. For each stage transition, define a metric:

| Transition | Metric | Solopreneur Benchmark |
|---|---|---|
| Awareness → Consideration | Click-through rate on ads / organic traffic to site | Ads: 2-5% CTR. Organic: measure traffic volume |
| Consideration → Decision | Signup / trial signup rate | 2-5% of visitors |
| Decision → Purchase | Trial-to-paid conversion | 2-5% (SaaS). 10-20% (one-time products) |
| Purchase → Activation | % of new customers who complete onboarding | Target: 80%+ |
| Activation → Retention | 30-day retention rate | Target: 60%+ |
| Retention → Expansion | Upgrade or upsell rate | Target: 10-20% per year |

**Track these monthly.** The stage with the biggest drop-off is where to focus all optimization effort.

---

## Step 4: Identify and Fix Your Biggest Leak

Run this diagnostic:

1. Calculate the conversion rate at every stage (use Step 3 metrics).
2. Find the stage with the lowest conversion rate OR the biggest absolute drop in numbers.
3. That stage is your "leak." Fix it before touching anything else.

**Common leaks and fixes:**

| Leak Location | Common Cause | Fix |
|---|---|---|
| Awareness → Consideration (low traffic) | Not findable / wrong channels | Double down on one channel. Invest in SEO or targeted ads. |
| Consideration → Decision (low signups) | Trust deficit / unclear value | Add social proof. Clarify value prop on homepage. Offer free trial. |
| Decision → Purchase (low conversion) | Price shock / friction / objections | Add FAQ. Offer guarantee. Simplify checkout. Test lower price. |
| Purchase → Activation (low onboarding) | Confusing first experience | Rebuild onboarding. Guide to first value in < 5 min. |
| Activation → Retention (high churn) | Product not delivering on promise | Talk to churned customers. Fix the core product gap. |

---

## Step 5: Automate What You Can

As a solopreneur, you cannot manually touch every lead. Automate the repetitive stages:

- **Awareness → Consideration:** SEO does this automatically. Paid ads run on autopilot.
- **Consideration → Decision:** Email sequences triggered by signup. Retargeting ads for website visitors.
- **Purchase → Activation:** Automated onboarding email sequence. In-app guided tour.
- **Retention:** Automated usage-based nudges. Scheduled check-in emails. Automated renewal reminders.

**What should NOT be automated (for high-touch funnels):**
- Discovery calls
- Proposal delivery and discussion
- The actual close conversation
- First check-in after purchase (personal touch here builds loyalty)

---

## Funnel Mistakes to Avoid
- Building a funnel and never measuring it. A funnel without metrics is just a theory.
- Optimizing the top of the funnel (awareness) when the bottom is leaking. More traffic into a broken funnel = more wasted money.
- Making the funnel too long. Every extra step loses people. Cut stages that don't add value.
- Ignoring the post-purchase funnel. Retention and expansion are where the real money is. Most solopreneurs focus 90% on acquisition and 10% on retention — it should be closer to 60/40.
- One-size-fits-all funnel for all customer segments. A $9/month self-serve customer and a $500/month enterprise customer need completely different funnels.
