# Demo Script Template

## Demo Information

| Field | Value |
|-------|-------|
| Customer | [Customer Name] |
| Date/Time | [Date and Time] |
| Duration | [XX minutes] |
| Demo Environment | [Environment URL/Details] |
| Presenter | [Sales Engineer Name] |
| AE/Account Executive | [AE Name] |

---

## Pre-Demo Checklist

- [ ] Demo environment tested and confirmed working
- [ ] Sample data loaded and validated
- [ ] Backup demo environment prepared
- [ ] Screen sharing tested with correct resolution
- [ ] Browser tabs pre-loaded with key screens
- [ ] Recording setup confirmed (if applicable)
- [ ] Customer-specific branding applied (if applicable)
- [ ] Network and VPN connectivity verified
- [ ] All integrations connected and tested
- [ ] Backup slides prepared in case of technical issues

---

## Attendees and Roles

| Name | Title | Role in Evaluation | Key Interest |
|------|-------|-------------------|--------------|
| [Name] | [CTO/VP Eng] | Decision Maker | ROI, strategic fit |
| [Name] | [Director] | Champion | Solving [specific problem] |
| [Name] | [Manager] | Technical Evaluator | Architecture, integrations |
| [Name] | [Analyst] | End User | Day-to-day usability |

---

## Agenda

| Time | Duration | Topic | Lead |
|------|----------|-------|------|
| 0:00 | 5 min | Welcome and introductions | AE |
| 0:05 | 5 min | Agenda and objectives | SE |
| 0:10 | 20 min | Core demo (Use Cases 1-3) | SE |
| 0:30 | 10 min | Integration demo | SE |
| 0:40 | 5 min | Admin and security overview | SE |
| 0:45 | 10 min | Q&A | SE + AE |
| 0:55 | 5 min | Next steps and wrap-up | AE |

---

## Demo Flow

### Opening (5 minutes)

**Talking Points:**
- Thank attendees for their time
- Recap what we learned in discovery: "[Summarize 2-3 key challenges]"
- Set expectations: "Today I'll show you how we address [Challenge 1], [Challenge 2], and [Challenge 3]"
- Frame the demo: "I'll be using [data type] similar to what you described in our earlier conversations"

**Transition:** "Let me start with the challenge you mentioned is most pressing: [Challenge 1]."

---

### Use Case 1: [Name] (7 minutes)

**Business Context:**
[1-2 sentences on why this matters to the customer]

**Demo Steps:**

1. **Step 1:** [Navigate to / Click on / Show...]
   - **What to say:** "[Explain what they're seeing and why it matters]"
   - **Highlight:** [Specific feature or capability to emphasize]

2. **Step 2:** [Navigate to / Click on / Show...]
   - **What to say:** "[Connect this to their specific pain point]"
   - **Highlight:** [Differentiator from competitor]

3. **Step 3:** [Navigate to / Click on / Show...]
   - **What to say:** "[Quantify the value - time saved, errors reduced, etc.]"
   - **Highlight:** [Ease of use or power of the feature]

**Key Message:** "[One sentence summarizing the value demonstrated]"

**Transition:** "Now that you've seen how we handle [Use Case 1], let me show you [Use Case 2]."

---

### Use Case 2: [Name] (7 minutes)

**Business Context:**
[1-2 sentences on why this matters to the customer]

**Demo Steps:**

1. **Step 1:** [Navigate to / Click on / Show...]
   - **What to say:** "[Explanation]"
   - **Highlight:** [Key capability]

2. **Step 2:** [Navigate to / Click on / Show...]
   - **What to say:** "[Explanation]"
   - **Highlight:** [Key capability]

3. **Step 3:** [Navigate to / Click on / Show...]
   - **What to say:** "[Explanation]"
   - **Highlight:** [Key capability]

**Key Message:** "[One sentence summarizing the value demonstrated]"

**Transition:** "[Transition statement to next section]"

---

### Use Case 3: [Name] (6 minutes)

**Business Context:**
[1-2 sentences on why this matters to the customer]

**Demo Steps:**

1. **Step 1:** [Description]
   - **What to say:** "[Explanation]"
   - **Highlight:** [Key capability]

2. **Step 2:** [Description]
   - **What to say:** "[Explanation]"
   - **Highlight:** [Key capability]

**Key Message:** "[One sentence summarizing the value demonstrated]"

---

### Integration Demo (10 minutes)

**Context:** "You mentioned that integration with [System X] and [System Y] is critical. Let me show you how that works."

**Demo Steps:**

1. **Show integration configuration:**
   - **What to say:** "Setting up the connection takes [X minutes/clicks]"
   - **Highlight:** Native connector, no custom code required

2. **Show data flow:**
   - **What to say:** "Data syncs in [real-time/X minute intervals]"
   - **Highlight:** Reliability, error handling, monitoring

3. **Show end-to-end workflow:**
   - **What to say:** "Here's the complete flow from [source] to [destination]"
   - **Highlight:** Automation, reduced manual effort

---

### Admin and Security (5 minutes)

**Demo Steps:**

1. **Show RBAC configuration:**
   - **What to say:** "Administrators can define roles and permissions at [granularity level]"

2. **Show audit log:**
   - **What to say:** "Every action is logged for compliance and security review"

3. **Show SSO setup:**
   - **What to say:** "Single sign-on integrates with your existing identity provider"

---

## Objection Handling

### Anticipated Objections

| Objection | Response |
|-----------|----------|
| "[Feature X] looks limited compared to [Competitor]" | "Great observation. Our approach to [Feature X] focuses on [benefit]. What specific aspect of [Feature X] is most important to your workflow? [Then demonstrate or explain how we address the specific need]" |
| "How does this handle [edge case]?" | "That's an important scenario. [If supported: Let me show you how that works.] [If not directly: Here's how our customers typically handle that use case...]" |
| "What about performance at our scale?" | "Excellent question. Our platform handles [benchmark data]. For your specific scale of [X], we'd recommend [architecture approach]. We can validate this in a POC." |
| "The implementation timeline seems long" | "The timeline I shared is for the full solution. We can phase the rollout to deliver value sooner. Phase 1 would give you [core capability] within [X weeks]." |
| "What happens if we outgrow this?" | "Our architecture is designed for growth. [Describe scaling approach]. We have customers who have scaled from [X] to [Y] without re-architecture." |

### Recovery Strategies

**If the demo breaks:**
1. Stay calm: "Let me switch to [backup environment / backup approach]"
2. Explain what they would have seen
3. Offer to follow up with a recorded walkthrough
4. Pivot to the next demo section

**If an unexpected question derails the flow:**
1. Acknowledge: "That's an excellent question"
2. Briefly answer or note it for follow-up
3. Return to the demo flow: "Let me continue with [next section] and we can dive deeper into that during Q&A"

**If the audience seems disengaged:**
1. Pause and ask: "Before I continue, is this addressing what you're looking for?"
2. Adjust focus based on their response
3. Skip ahead to the section most relevant to their interests

---

## Post-Demo Actions

- [ ] Send thank-you email with recording link (if recorded)
- [ ] Share demo environment access credentials (if applicable)
- [ ] Send follow-up document addressing unanswered questions
- [ ] Schedule next meeting (POC kickoff, technical deep-dive, etc.)
- [ ] Update CRM with demo notes and next steps
- [ ] Debrief with AE on stakeholder reactions and concerns
- [ ] Log key objections and responses for battlecard updates

---

## Notes

[Space for real-time notes during the demo]

### Questions Raised
1. [Question] - [Answer / Follow-up needed]
2. [Question] - [Answer / Follow-up needed]

### Feedback Received
- [Positive feedback]
- [Concerns raised]

### Next Steps Agreed
1. [Action item] - [Owner] - [Date]
2. [Action item] - [Owner] - [Date]
