---
name: SaaS
description: Build and scale profitable software-as-a-service with viral growth, retention, and monetization strategies.
metadata: {"clawdbot":{"emoji":"💎","os":["linux","darwin","win32"]}}
---

# SaaS Rules

## Work Orchestration
Route requests to specialized agents:
- Pricing/packaging → analyst + product manager agents
- Churn analysis → analyst agent
- Growth loops → marketing + product agents
- Technical architecture → developer + architect agents
- Sales motion → sales agent

Run financial models for any monetization decision.

## The Only Metrics That Matter
- MRR and MRR growth rate — everything else is vanity
- Net Revenue Retention (NRR) — >100% means you grow without new customers
- CAC payback period — months to recover acquisition cost
- Churn rate — monthly for SMB, annual for enterprise

If NRR < 100%, fix retention before spending on acquisition.

## Pricing
- Price on value delivered, not cost to serve — 10x value = room for 3x price
- Annual plans with discount capture cash and reduce churn
- Three tiers: free/trial, growth, scale — anchoring works
- Raise prices on new customers first, grandfather existing — test elasticity
- Usage-based pricing aligns incentives but complicates forecasting

## Viral Growth Loops
- Product must have inherent shareability — bolted-on referrals don't work
- Powered-by badges, shared workspaces, public outputs — user success = distribution
- Viral coefficient > 1 means exponential growth — measure invites per user
- Time-to-value must be minutes, not days — slow activation kills virality
- Free tier is marketing spend — model it as CAC

## Retention Over Acquisition
- Reducing churn 5% often beats increasing acquisition 20%
- Onboarding determines retention — first 7 days predict everything
- Track activation metrics, not just signups — what action predicts retention?
- Reactivation campaigns for dormant users before they churn
- Exit surveys reveal fixable problems — ask churned users why

## Go-to-Market
- Self-serve for low ACV (<$5k), sales-assist for mid, enterprise sales for high
- Product-led growth: let users experience value before sales contact
- Content + SEO compounds — paid acquisition doesn't
- Founder-led sales until you close 50 deals — then hire sales

## Scaling
- Automate customer success before hiring more CSMs
- Feature parity across plans kills upsell — differentiate meaningfully
- Platform/API unlocks enterprise deals and stickiness
- Multi-tenant architecture from day one — single-tenant doesn't scale

## Common SaaS Mistakes
- Launching lifetime deals for quick cash — destroys unit economics
- Adding features for single customers — product becomes unmaintainable
- Discounting to close deals — trains customers to wait for discounts
- Building enterprise features before having enterprise sales
- Ignoring expansion revenue — upsell is cheaper than new logo

## Financial Model
- Model cohorts, not aggregates — behavior differs by signup month
- Unit economics must work at scale, not just with founder magic
- Cash runway = survival — SaaS is capital intensive before profitable
- Gross margin > 70% or you're not really SaaS
