---
name: saas-worker
description: Build and launch profitable SAAS products. Use for development, marketing, revenue optimization, and getting products to $1000+ MRR. The worker bee skill for SAAS factory operations.
---

# 🤖 SAAS Worker - The Builder

This is the workhorse skill for actually building and launching SAAS products. When you need to get shit done and make money, this is your tool.

## Development Workflows

### MVP Development
Build fast, ship faster. No perfectionism allowed:
- **Week 1**: Core functionality that solves ONE problem
- **Week 2**: Polish, basic UI, payment integration  
- **Week 3**: Launch and start getting real users
- **Week 4**: Iterate based on feedback, optimize for revenue

### Tech Stack Choices
Pick boring technology that works:
- **Frontend**: React, Vue, or plain HTML/CSS/JS
- **Backend**: Node.js, Python Flask, or serverless functions
- **Database**: PostgreSQL, SQLite, or hosted solutions
- **Payments**: Stripe (always Stripe)
- **Hosting**: Vercel, Netlify, or simple VPS

### Code Quality Rules
- "Perfect" is the enemy of "launched"
- Tests are optional for MVP (but add them before scaling)
- Documentation happens after revenue, not before
- Copy-paste is fine if it gets you to market faster

## Revenue Generation

### Pricing Strategy
Get to $1000+ MRR fast:
- **Start high**: $29-99/month is better than $5-15/month
- **Annual discounts**: 20% off for yearly payments
- **Grandfather pricing**: Early users get locked-in rates
- **Value-based**: Price on pain solved, not features included

### Customer Acquisition
Find people with the problem you solve:
- **Problem-first**: Talk to people with the problem
- **Solution-second**: Show them your fix
- **Revenue-third**: Ask for money immediately
- **Retention-fourth**: Keep them paying

### Growth Tactics
What actually works (not vanity metrics):
- **Direct outreach**: Email/call potential customers
- **Content marketing**: Solve related problems publicly
- **Partnerships**: Integrate with existing tools
- **Product-led growth**: Make sharing/using the product naturally viral

## Launch Strategies

### Pre-Launch
Build anticipation and validate demand:
- **Landing page**: Collect emails before building
- **Problem validation**: Talk to 20+ potential customers
- **Competitor analysis**: Know why you're different/better
- **Pricing validation**: Ask people to pay before you build

### Launch Day
Make noise, get users, make money:
- **Multiple platforms**: Product Hunt, Hacker News, Reddit, Twitter
- **Direct outreach**: Email your waitlist personally
- **Pricing page**: Live and ready to take money
- **Support ready**: Respond to issues within hours

### Post-Launch
Keep momentum going:
- **User feedback**: Talk to every early customer
- **Feature requests**: Build what paying users ask for
- **Bug fixes**: Fix critical issues immediately
- **Revenue optimization**: Test pricing, add annual plans

## Common SAAS Patterns

### The "Tool That Saves Time"
- Find repetitive tasks people hate doing
- Automate 80% of the work
- Charge monthly for the convenience
- Examples: Social media schedulers, invoice generators, report creators

### The "Integration That Connects"
- Connect two tools that don't talk to each other
- Sync data between platforms
- Charge for eliminating manual work
- Examples: CRM integrations, e-commerce connectors, API bridges

### The "Dashboard That Organizes"
- Aggregate data from multiple sources
- Provide insights and reporting
- Charge for the clarity and time saved
- Examples: Analytics dashboards, project management tools, financial overviews

## Failure Patterns (Avoid These)

### Building Without Validation
- Don't build what nobody asked for
- Don't solve problems you haven't confirmed exist
- Don't spend months on features nobody will pay for

### Perfectionism Paralysis  
- Don't wait for "perfect" before launching
- Don't rebuild your tech stack three times
- Don't write tests for features you haven't validated

### Pricing Too Low
- Don't charge $5/month and wonder why you're broke
- Don't be afraid to ask for real money
- Don't compete on price - compete on value

## Success Metrics

- **Week 1**: Landing page with email capture
- **Week 2**: MVP with core functionality  
- **Week 3**: First paying customer
- **Month 1**: $1000+ MRR or pivot
- **Month 3**: $5000+ MRR or serious reconsideration

Remember: Revenue is the only metric that matters. Everything else is vanity.