---
name: saas-revenue-tracker
description: Track SAAS revenue, MRR growth, customer metrics, and profitability. Use to monitor $1000+ MRR targets, identify optimization opportunities, and keep SAAS products profitable.
---

# 💰 SAAS Revenue Tracker - The Money Monitor

This skill keeps your SAAS empire honest about revenue. No feel-good metrics here - just cold, hard cash flow analysis.

## Revenue Tracking

### Core Metrics We Track
- **MRR (Monthly Recurring Revenue)**: The holy grail number
- **ARR (Annual Recurring Revenue)**: MRR × 12, but focus on MRR
- **Churn Rate**: Customers leaving (keep this under 5% monthly)
- **Customer LTV**: How much each customer is worth
- **CAC (Customer Acquisition Cost)**: How much to get each customer
- **LTV:CAC Ratio**: Should be 3:1 minimum

### $1000+ MRR Targets
Every SAAS must hit these minimums or it's not a real business:
- **Month 1**: $1000 MRR minimum
- **Month 3**: $3000 MRR (3x growth)
- **Month 6**: $7500 MRR (sustainable growth)
- **Month 12**: $15000 MRR (real business territory)

### Revenue Categories
**The Good (Keep Building)**:
- Growing 10%+ monthly
- Low churn (<5% monthly)
- High LTV:CAC ratio (>3:1)
- Organic growth happening

**The Bad (Needs Work)**:
- Flat growth for 2+ months
- High churn (>10% monthly)
- CAC too high (taking >12 months to pay back)
- No organic/referral growth

**The Ugly (Kill or Pivot)**:
- Declining revenue for 3+ months
- Can't get to $1000 MRR after 6 months
- CAC never pays back
- Market too small or saturated

## Customer Analysis

### Customer Segments
Know who's paying you and why:
- **Whales** (Top 20% of customers, 80% of revenue)
- **Core** (Steady customers, consistent revenue)
- **Churners** (Leave quickly, learn from them)
- **Free Trials** (Convert or die)

### Pricing Optimization
Test these systematically:
- **Price Increases**: Test 20-50% increases annually
- **Annual Plans**: 20% discount for yearly payment
- **Tier Restructuring**: Add/remove features from tiers
- **Grandfathering**: Honor old pricing for existing customers

### Revenue Levers
What actually moves the needle:
1. **Reduce Churn** (easiest wins)
2. **Increase Prices** (test carefully)
3. **Add Annual Plans** (cash flow boost)
4. **Upsell Existing** (expand revenue per customer)
5. **Improve Conversion** (more trials → customers)

## Financial Health Checks

### Monthly Review Process
Every month, ask these questions:
- Are we hitting our MRR targets?
- What's our churn rate trend?
- Which customers are our biggest risks?
- Where is growth coming from?
- What needs to change next month?

### Red Flags (Act Immediately)
- MRR declining for 2+ months
- Churn rate increasing month-over-month
- CAC increasing while conversion decreases
- Big customers threatening to leave
- Payment failures increasing

### Green Flags (Double Down)
- MRR growing 15%+ monthly
- Churn rate decreasing
- Organic/referral customers increasing
- Annual plan adoption growing
- Customer satisfaction scores high

## Revenue Forecasting

### Simple Growth Model
Conservative forecasting for planning:
- **Base Case**: Current growth rate continues
- **Optimistic Case**: 50% acceleration in growth
- **Pessimistic Case**: 25% deceleration in growth

### Cash Flow Planning
Know when you'll run out of money:
- **Burn Rate**: Monthly expenses
- **Runway**: Months of cash remaining
- **Break-even**: When revenue covers costs
- **Growth Capital**: Money needed for acceleration

## Action Framework

### When Revenue is Growing
- **Accelerate**: Double down on what's working
- **Scale**: Hire, increase marketing spend
- **Optimize**: Improve conversion and retention
- **Plan**: Set bigger targets for next quarter

### When Revenue is Flat
- **Diagnose**: Find the bottleneck (acquisition, conversion, retention)
- **Experiment**: Test new channels, pricing, features
- **Cut**: Reduce spending on what's not working
- **Focus**: Concentrate on one growth lever at a time

### When Revenue is Declining
- **Emergency**: Treat this like the business is dying (it might be)
- **Talk**: Call every customer, understand why they're leaving
- **Pivot**: Consider major changes to product/market
- **Decide**: Fix quickly or shut down and move on

## Success Metrics Dashboard

### Daily (Automated)
- MRR total and daily change
- New customers and churn
- Trial signups and conversion rate
- Payment failures and recoveries

### Weekly (Review)
- Growth rate trends
- Customer segment performance
- Marketing channel effectiveness
- Support ticket themes

### Monthly (Deep Dive)
- Full financial analysis
- Customer interview insights
- Competitive landscape changes
- Strategic planning updates

Remember: Revenue is vanity, profit is sanity, cash is reality. Track all three or you're flying blind.