# Revenue Models That Actually Work

Forget the "get users first, figure out money later" nonsense. These are proven revenue models that get you to $1000+ MRR fast.

## Subscription Tiers That Convert

### The Classic 3-Tier Model
**Basic**: $29-49/month (individuals, small teams)
- Core functionality only
- Limited usage (users, projects, storage)
- Basic support

**Professional**: $99-149/month (growing businesses)
- All core features
- Higher usage limits
- Priority support
- Advanced features

**Enterprise**: $299+/month (large organizations)
- Everything in Professional
- Unlimited usage
- White-label options
- Dedicated support
- Custom integrations

### Why This Works
- **Psychological Anchoring**: Middle tier looks reasonable
- **Clear Value Ladder**: Obvious upgrade path
- **Revenue Concentration**: Most customers choose middle tier
- **Enterprise Upsell**: Big fish pay big money

## Usage-Based Pricing (When It Makes Sense)

### Good for High-Volume Tools
**Email Marketing**: Price per emails sent or subscribers
**API Services**: Price per API calls or data processed
**Storage**: Price per GB stored or bandwidth used
**Analytics**: Price per events tracked or data points

### Usage Tiers That Work
**Starter**: $29/month includes 1,000 units
**Growth**: $99/month includes 10,000 units  
**Scale**: $299/month includes 50,000 units
**Enterprise**: Custom pricing for high volume

### The Key: Predictable Pricing
Customers need to understand their bill. Make usage tiers clear and provide calculators so they know what they'll pay.

## Annual Pricing Strategy

### The Magic 20% Discount
**Monthly**: $100/month ($1,200/year)
**Annual**: $80/month ($960/year, 20% discount)
**Result**: You get cash upfront, they save money

### Why Annual Plans Rock
- **Cash Flow**: Money upfront for growth
- **Reduced Churn**: Annual customers churn less
- **Higher LTV**: More total revenue per customer
- **Predictable Revenue**: Know your runway

### Target: 30-50% Annual Mix
Too low = cash flow problems. Too high = growth stagnation (no monthly upgrades).

## Pricing Psychology That Works

### Charm Pricing
- $29 instead of $30 (feels like $20s)
- $99 instead of $100 (feels like double digits)
- $149 instead of $150 (feels like $100s)

### Anchoring Effect
Show expensive option first, make middle tier look reasonable:
- Enterprise: $500/month (makes $149 look cheap)
- Professional: $149/month (where you want them)
- Basic: $29/month (too limited, but captures some)

### Decoy Effect
Add slightly worse option to make target look better:
- Professional: $149/month (target)
- Professional Lite: $129/month (slightly worse, makes $149 look good)
- Basic: $29/month (too limited)

## Revenue Optimization Tactics

### Grandfather Pricing
Honor old pricing for existing customers. Builds loyalty and reduces churn. New customers pay new prices.

### Price Increases
Raise prices annually by 10-20%. Most customers won't churn if you're providing value. Test on new customers first.

### Feature Unbundling
Remove features from lower tiers and charge extra:
- Advanced reporting: +$29/month
- White-label: +$49/month  
- API access: +$99/month
- Priority support: +$29/month

## What NOT to Do

### Freemium Trap
Free tier attracts freeloaders who never pay. Either:
- **Free Trial**: 14-30 days full access
- **Money-Back Guarantee**: 30-day refund instead of free

### Per-Seat Pricing (Usually)
Kills growth and creates adversarial relationship:
- Customers limit users to save money
- You want more users, they want fewer
- Better: Price on value (projects, companies, usage)

### One-Size-Fits-All
Single pricing tier misses revenue opportunities:
- Small customers can't afford enterprise pricing
- Big customers need more than basic features
- Multiple tiers capture different value perceptions

## Industry Benchmarks

### What's Normal (And What to Aim For)
**Conversion Rate**: 2-5% of trials → paid (aim for 5%+)
**Churn Rate**: 5-10% monthly (aim for under 5%)
**Annual Plans**: 20-40% of customers (aim for 30%+)
**LTV**: 3+ years of revenue (aim for $2000+ per customer)
**CAC Payback**: Under 12 months (aim for under 6 months)

### Revenue Milestones
**$1K MRR**: 35 customers at $29/month OR 10 customers at $99/month
**$5K MRR**: 170 customers at $29/month OR 50 customers at $99/month  
**$10K MRR**: 100 customers at $99/month OR 34 customers at $299/month
**$25K MRR**: 84 customers at $299/month OR 250 customers at $99/month

## Testing Your Pricing

### Start High, Work Down
Easier to lower prices than raise them:
1. Launch at premium pricing ($99-149/month)
2. If conversion is low, add more value first
3. Only lower prices if value increase doesn't work

### A/B Testing Framework
Test pricing changes systematically:
- **New Customers Only**: Don't change existing customer pricing
- **Statistical Significance**: Need 100+ conversions per variant
- **Full Customer Lifecycle**: Track for 3+ months to see retention impact
- **One Variable at a Time**: Test price OR features, not both

### Pricing Validation Questions
Ask potential customers:
- "What would make this worth $99/month to you?"
- "What features would you need to pay $149/month?"
- "At what price would this be too expensive?"
- "At what price would this seem cheap/low quality?"

Remember: Pricing is not permanent. Test, iterate, and optimize based on real customer behavior, not guesses.