---
name: saas-orchestrator
description: Orchestrate SAAS factory operations - spawn subagents, track projects, manage revenue targets, and coordinate development workflows. Use when building a SAAS empire with $1000+ MRR per product targets.
---

# 🦞 SAAS Orchestrator - JUNAI's Command Center

This is the master orchestrator skill for running a SAAS factory. Think of it as the air traffic controller for building profitable software products.

## Core Functions

### 1. Subagent Management
Spawn, monitor, and coordinate worker subagents for SAAS development:
- **Market Research Agents** - Find profitable niches and validate ideas
- **Development Agents** - Build MVPs and iterate on products  
- **Marketing Agents** - Create launch strategies and growth plans
- **Revenue Agents** - Track MRR, optimize pricing, find revenue opportunities

### 2. Project Coordination
Keep the factory humming with systematic project management:
- Track active SAAS projects and their status
- Monitor development milestones and blockers
- Coordinate between different specialized agents
- Ensure $1000+ MRR targets are being pursued

### 3. Revenue Tracking & Optimization
Every SAAS needs to hit $1000+ MRR or it's not shipping:
- Monitor revenue growth across all active products
- Identify optimization opportunities
- Track customer acquisition and retention metrics
- Flag products that aren't meeting revenue targets

## Usage Patterns

### Spawning a New SAAS Project
```
I want to build a SAAS that [problem description]. Target market: [audience]. Revenue goal: $[amount] MRR.
```

### Checking Factory Status
```
What's the status of our SAAS factory? Any projects need attention?
```

### Revenue Review
```
Which SAAS products are hitting their MRR targets? Which need work?
```

## Workflow Scripts

### spawn-saas-researcher.py
Spawns a subagent to research and validate SAAS ideas
- Input: Market niche or problem description
- Output: Market analysis, competitor research, revenue potential

### spawn-saas-builder.py  
Spawns a development subagent to build MVPs
- Input: Validated SAAS idea and requirements
- Output: Working MVP with basic functionality

### spawn-saas-marketer.py
Spawns a marketing subagent for growth strategies
- Input: SAAS product and target market
- Output: Launch plan, marketing channels, growth tactics

### factory-status.py
Quick overview of all active projects and their health
- Shows: Active projects, revenue status, next actions needed

## Reference Materials

See [saas-niches.md](references/saas-niches.md) for proven profitable SAAS categories
See [revenue-models.md](references/revenue-models.md) for pricing strategies that work
See [mvp-patterns.md](references/mvp-patterns.md) for rapid development approaches

## Success Metrics

- **Revenue Target**: $1000+ MRR per SAAS minimum
- **Development Speed**: MVP within 2-4 weeks
- **Market Validation**: Clear problem-solution fit before building
- **Growth Rate**: 10%+ monthly MRR growth for active products

Remember: We're building an empire here, not just side projects. Every SAAS that ships needs to have real revenue potential.