# 🌎 S2S Model Builder

An end-to-end builder skill for AI-based Subseasonal-to-Seasonal (S2S) forecasting systems.

Generates runnable PyTorch code for:

- FuXi-style transformers
- FengWu-style Earth models
- AIFS-inspired probabilistic systems
- CRPS-based training
- Multi-lead-time forecasting

---

## What This Skill Does

- Scaffolds full model architectures
- Generates training loops
- Implements CRPS
- Creates evaluation pipelines
- Designs distributed training setups

This skill generates transparent, local code only. No external APIs are called.

---

## Intended Users

- Climate AI researchers
- Earth system ML engineers
- Research labs building S2S systems
- Advanced ML practitioners

---

## Installation

Upload:

SKILL.md  
README.md  

to ClawHub via Publish Skill.

---

## Version

1.0.0
