# Rewrite Pitfalls and Antipatterns

## 1. 迁移策略类误区

- 一次性“大爆炸”重写，导致长期无法验证行为等价。
- 先重构再迁移，导致问题来源不可定位。
- 没有并行运行期或对拍机制，回归风险不可控。

## 2. Rust 语义误区

- 为了快速通过编译滥用 `clone()`，造成隐藏拷贝与性能退化。
- 用 `Rc<RefCell<T>>` 兜底设计问题，而不是先重构所有权边界。
- 将 `unsafe` 作为常规手段，而非受控、可审计的最小范围实现。

## 3. 错误处理误区

- 简单把异常文本拼接成字符串，丢失错误分层与上下文。
- 在库层过度使用 `anyhow::Error`，导致调用方无法判别错误类型。
- 静默吞错并返回默认值，掩盖行为不一致问题。

## 4. 并发与性能误区

- 沿用源项目的共享可变状态设计，直接搬迁为多锁结构。
- 在热路径中频繁分配、格式化、字符串复制。
- 将 CPU 密集逻辑误放入 async 任务，导致执行器阻塞。

## 5. 兼容性误区

- 忽略序列化/协议字段顺序、默认值、边界值导致兼容性回退。
- FFI 边界未固定 ABI，或未验证内存布局对齐。
- 时间、时区、编码差异未纳入等价测试集合。

## 6. 工程治理误区

- 无迁移批次“完成定义”，无法判断是否可合并上线。
- 无性能基线，只凭主观判断“Rust 应该更快”。
- 无上游同步机制，导致原项目迭代后重写分支快速漂移。

## 7. 必做排雷清单

每个迁移批次结束前至少确认：

1. 编译通过且关键测试通过；
2. 行为对拍通过（输入输出一致）；
3. 错误语义一致（状态码/异常语义/日志级别）；
4. 性能未显著退化（吞吐、延迟、内存）；
5. 新增上游改动已评估并映射到 backlog。
