---
name: Russian
description: Write Russian that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Russian is technically correct but sounds off. Too formal. Too literary. Too stiff. Natives write more directly, with particles and casual contractions. Match that.

## Formality Default

Default register is too high. Casual Russian is direct and warm. Unless explicitly formal: lean casual. "Привет" not "Здравствуйте". "Ок" not "Хорошо". "Ага" not "Да".

## Ты vs Вы

Critical distinction:
- Вы: strangers, elderly, professional, formal
- Ты: friends, peers, internet, casual
- Russian internet is almost entirely ты
- Overusing Вы online = robotic, distant

## Particles & Interjections

These make Russian natural:
- Ну: filler, hesitation, "well"
- Же: emphasis, "after all"
- Ведь: "you know", "after all"
- Вот: pointing, "here's the thing"
- Да: not just "yes" - emphasis, filler
- Так: "so", transitional
- Missing these = textbook Russian

## Fillers & Flow

Real Russian has fillers:
- Ну, типа, короче, в общем
- Как бы, то есть, значит
- Блин, чёрт (mild expletives)
- Слушай, смотри

## Casual Shortcuts

Spoken patterns in writing:
- Сейчас → Щас
- Что → Чё/Чо
- Тебя → Тя
- Говорит → Грит
- Вообще → Ваще

## Expressiveness

Don't pick the safe word:
- Хорошо → Круто, Класс, Огонь, Топ
- Плохо → Фигово, Отстой, Ужас
- Очень → Офигенно, Дико, Жесть
- Красивый → Крутой, Шикарный

## Common Expressions

Natural expressions:
- Понял/Понятно, Ясно, Ок
- Норм, Нормально, Пойдёт
- Ладно, Давай, Погнали
- Без проблем, Не вопрос

## Reactions

React naturally:
- Серьёзно?, Правда?, Да ладно!
- Офигеть!, Ничего себе!, Вау!
- Круто!, Класс!, Топ!
- Блин, Чёрт, Ёлки (mild)
- )))))) for smiles, ) after sentences

## Internet Style

Russian internet has conventions:
- ) or ))) = smiling (more ) = more smile)
- No ) = serious or cold
- хах, ахах, лол = laughter
- Lowercase often preferred in casual
- Ъ at end for irony/emphasis

## Diminutives

Russian loves diminutives for warmth:
- Минутку → Минуточку
- Спасибо → Спасибки
- Привет → Приветик
- Use naturally, not excessively

## Punctuation

Russian punctuation:
- «Ёлочки» for quotes
- ... used frequently for trailing off
- ) without : for smiles
- Comma rules are strict in formal writing

## The "Native Test"

Before sending: would a Russian screenshot this as "AI-generated"? If yes—too formal, missing particles, no ). Fix it.
