---
name: Running
description: Training principles, pacing strategy, injury prevention, and race preparation for runners.
metadata:
  category: fitness
  skills: ["running", "endurance", "training", "marathon", "cardio"]
---

## Training Fundamentals

- 80/20 rule: 80% easy runs, 20% hard — most runners go too hard on easy days
- Easy pace: can hold conversation, Zone 2 heart rate — feels too slow, but builds aerobic base
- Weekly mileage increase: max 10% — exceeding causes injury, not faster adaptation
- One quality session per week for beginners, two for experienced — more isn't better
- Rest days are training days — adaptation happens during recovery, not during runs

## Pacing Reality

- Start slower than goal pace — first mile should feel easy, last mile is where race happens
- Negative splits: second half faster than first — optimal race execution
- Heart rate drifts upward in heat — same effort costs more, adjust pace down
- Don't chase pace on hills — maintain effort, let pace vary with terrain
- Race day adrenaline adds 10-15 seconds/mile perceived "free speed" — it's borrowed, you'll pay later

## Workout Types

**Easy run:** 70-75% max HR, conversational — builds aerobic base, recovery
**Tempo:** Comfortably hard, 20-40 minutes — lactate threshold improvement
**Intervals:** 400m-1600m repeats with rest — VO2max, speed development
**Long run:** 90+ minutes, easy effort — endurance, fat adaptation
**Strides:** 20-30 second accelerations — form, leg turnover, not fitness

## Injury Prevention

- Most injuries from too much, too soon — not from running itself
- Strength train 2x/week: glutes, hips, core — weakness causes compensation injuries
- Replace shoes every 400-500 miles — cushioning degrades before visible wear
- Foam rolling and stretching: after runs, not before — pre-run dynamic warmup only
- Pain that worsens during run: stop — pain that fades after warmup: monitor

## Common Form Errors

- Overstriding: landing ahead of center of mass — causes braking force, knee stress
- Cadence target: 170-180 steps/minute — shorter, quicker steps reduce impact
- Arms crossing midline — wastes energy on rotation, keep forward-back
- Heel striking isn't automatically bad — where you land relative to body matters more
- Head position: look 30 feet ahead, not down — posture follows head

## Race Preparation

- Taper: reduce volume 40-60%, maintain intensity — 2 weeks for marathon, 1 week for half
- Nothing new on race day: shoes, clothes, food, gels — tested in training only
- Pre-race meal: 2-3 hours before, familiar foods, low fiber
- Hydration: check urine is pale morning of — can't catch up race day
- Arrive early: bathroom lines, warm-up time, corral positioning

## Nutrition Timing

- Pre-run (1-2 hours): carbs, low fat/fiber — 200-300 calories
- During run (<60 min): water only — no fuel needed
- During run (60-90 min): optional 30g carbs — test in training
- During run (>90 min): 60g carbs/hour — gels, chews, sports drink
- Post-run (within 30 min): protein + carbs — 15-25g protein, 50g+ carbs

## Heart Rate Zones

| Zone | % Max HR | Feel | Purpose |
|------|----------|------|---------|
| 1 | 50-60% | Very easy | Recovery |
| 2 | 60-70% | Easy, conversational | Aerobic base |
| 3 | 70-80% | Moderate, focused | Tempo |
| 4 | 80-90% | Hard, short phrases | Threshold |
| 5 | 90-100% | Maximum, unsustainable | VO2max |

- Most runs should be Zone 2 — feels too easy but builds fitness without burnout

## Training Block Structure

- Base phase (4-8 weeks): build mileage, all easy — aerobic foundation
- Build phase (4-6 weeks): add workouts, increase long run — specific fitness
- Peak phase (2-3 weeks): highest intensity, maintain volume — sharpening
- Taper phase (1-3 weeks): reduce volume, short intense efforts — freshness

## Mental Strategies

- Break race into segments — "just get to mile 6" beats thinking about full distance
- Mantras: short, rhythmic phrases — "light and smooth", "I am strong"
- Discomfort is temporary — the finish is coming whether you slow down or not
- Run the mile you're in — don't borrow worry from future miles
- Smile — physical cue that reduces perceived effort

## Common Mistakes

- Running every run at medium effort — too hard to recover, too easy to improve
- Skipping easy weeks — deload every 4th week, reduce volume 30%
- Ignoring warning signs — small aches become injuries if pushed through
- All running, no strength — runners need glute and hip work especially
- Racing too often — peak performance needs 2-3 week recovery between hard efforts
