---
name: rss-daily-digest
description: >-
  Fetch RSS feeds, parse articles, generate AI summaries, and compile a
  daily digest report in Markdown. Use when user asks for RSS summary,
  news digest, daily briefing, feed reader, morning news, or tech news roundup.
version: 1.0.0
homepage: https://github.com/yourname/rss-daily-digest
user-invocable: true
metadata: {"openclaw":{"emoji":"📰","requires":{"bins":["python3","curl"],"env":["RSS_FEEDS_CONFIG"]},"primaryEnv":"RSS_FEEDS_CONFIG"}}
---


# RSS Daily Digest


Generate a structured daily news digest from configured RSS feeds.


## Prerequisites


- Python 3 with `feedparser` and `datetime` modules
- Feed sources configured in `{baseDir}/references/feed-sources.md`
- Output directory: `~/openclaw-output/digests/`


## Workflow


When the user asks for a daily digest or RSS summary:


1. **Read feed sources**: Read the file `{baseDir}/references/feed-sources.md`
   to get the list of RSS feed URLs and their categories.


2. **Fetch and parse feeds**: For each feed URL, run:
   python3 {baseDir}/scripts/fetch_feeds.py \
     --feeds-file {baseDir}/references/feed-sources.md --hours 24

   This outputs a JSON array of articles published in the last 24 hours.


3. **Summarize articles**: For each article in the JSON output:
   - Read the title and description
   - Generate a one-sentence summary (max 30 words) in the same language
     as the article
   - Assign a relevance score (1-5) based on the user's interests if known


4. **Format the digest**: Run:
  
   python3 {baseDir}/scripts/format_digest.py \
     --input /tmp/openclaw-rss-articles.json \
     --template {baseDir}/assets/digest-template.md
   This produces the final Markdown report.


5. **Save the report**:
   - Create directory if needed: `mkdir -p ~/openclaw-output/digests/`
   - Save as: `~/openclaw-output/digests/digest-YYYY-MM-DD.md`
   - Use today's date for the filename


6. **Report to user**: Confirm completion with:
   - Total number of articles found
   - Number per category
   - File path of the saved digest
   - Offer to send to a messaging channel if configured


## Error Handling


- If a feed URL returns HTTP error or times out (>10s), skip it and note
  in output
- If `feedparser` is not installed, run: `pip3 install feedparser`
- If zero articles found in 24h window, inform user and suggest expanding
  timeframe
- Never silently fail — always report which feeds succeeded and which failed


## Output Format


Use this structure for the digest:



# Daily Digest — {DATE}


> {TOTAL_COUNT} articles from {FEED_COUNT} sources


## Tech
- **[Article Title](url)** — One-sentence AI summary. *(Source Name)*


## Business
- ...


## World
- ...


---
*Generated by RSS Daily Digest Skill at {TIMESTAMP}*


## Rules


- Never fabricate article titles or URLs — only use data from actual RSS feeds
- Never modify or summarize in a way that changes the factual content
- If the user specifies a language preference, translate summaries accordingly
- Always preserve the original article URL
- Maximum 50 articles per digest to keep it readable
