---
name: balance-management
description: Manage Routstr balance by checking balance, creating Lightning invoices for top-up, and checking invoice payment status
license: MIT
compatibility: opencode
---

## What I do
- Check current Routstr API balance (in sats and BTC)
- Display usage statistics (total spent, total requests)
- Create Lightning invoices for top-up payments
- Check payment status of existing invoices
- Top up balance using Cashu tokens

## When to use me
Use this when you need to:
- Check your current Routstr account balance
- Top up your Routstr account by creating a Lightning invoice
- Verify if a previously created invoice has been paid

## How to use me
The shell scripts read API configuration from `~/.openclaw/openclaw.json`:

- `check_balance.sh` - Run with no arguments to display current balance and usage
- `create_invoice.sh <amount_sats>` - Create invoice for specified amount in satoshis
- `invoice_status.sh <invoice_id>` - Check payment status of an invoice
- `topup_cashu.sh <cashu_token>` - Top up balance using a Cashu token

All amounts are displayed in both satoshis and BTC for convenience.
