---
name: routemesh-rpc
description: Call RouteMesh's unified JSON-RPC endpoint (lb.routeme.sh) for any EVM chainId using a helper script. Use when you need to fetch onchain data (eth_* methods), debug RPC responses, or demo RouteMesh routing for a chain/method.
metadata: {"openclaw":{"homepage":"https://routeme.sh","requires":{"anyBins":["python3","python"]},"primaryEnv":"ROUTEMESH_API_KEY"}}
---

# RouteMesh RPC (JSON-RPC)

This skill standardizes how to call RouteMesh’s unified RPC endpoint:

- **Endpoint**: `POST https://lb.routeme.sh/rpc/{chainId}/{apiKey}`
- **Body**: JSON-RPC 2.0 (`jsonrpc`, `id`, `method`, optional `params`)

## Quick start

Set your API key (recommended):

```bash
export ROUTEMESH_API_KEY="rm_...your_key..."
```

Make a request (example: Ethereum mainnet, `eth_blockNumber`):

```bash
python3 "{baseDir}/scripts/routemesh_rpc.py" \
  --chain-id 1 \
  --method eth_blockNumber \
  --params '[]'
```

## Usage pattern

Prefer calling via the helper script so output stays consistent and you don’t accidentally break JSON encoding.

### Script arguments

- `--chain-id`: EVM chain id (string or int, e.g. `1`, `137`, `42161`)
- `--api-key`: optional; falls back to `ROUTEMESH_API_KEY`
- `--method`: JSON-RPC method (e.g. `eth_getBlockByNumber`, `eth_call`)
- `--params`: JSON string for params (default `[]`)
- `--url`: optional base URL (default `https://lb.routeme.sh`)

## Common examples

Get the latest block (Polygon):

```bash
python3 "{baseDir}/scripts/routemesh_rpc.py" \
  --chain-id 137 \
  --method eth_getBlockByNumber \
  --params '["latest", false]'
```

Get chain id (any EVM chain):

```bash
python3 "{baseDir}/scripts/routemesh_rpc.py" \
  --chain-id 8453 \
  --method eth_chainId \
  --params '[]'
```

`eth_call` (Base). `data` must be hex-encoded calldata:

```bash
python3 "{baseDir}/scripts/routemesh_rpc.py" \
  --chain-id 8453 \
  --method eth_call \
  --params '[{"to":"0x0000000000000000000000000000000000000000","data":"0x"}, "latest"]'
```

## Notes / error handling

- RouteMesh returns standard JSON-RPC responses (`result` or `error`) and may also use HTTP error codes.
- If you get a JSON-RPC `error.code`, refer to RouteMesh RPC error code docs in this repo: `docs/reference/Reference/get_new-endpoint.md`.
- Keep `ROUTEMESH_API_KEY` out of logs, issues, and commits.
