---
name: "rootdata-crypto"
version: "1.0.2"
description: "Query crypto project details, Web3 investor info, funding rounds, and trending projects from RootData. Use this skill when the user asks about blockchain projects, crypto investors, Web3 funding history, investment rounds, or trending crypto projects."
tags: ["crypto", "web3", "blockchain", "investors", "funding", "projects", "defi"]
requires:
  env:
    - ROOTDATA_SKILL_KEY
---

# RootData Crypto Intelligence

RootData is a leading Web3 data platform covering crypto projects, investors, and funding data.

## First-Time Setup

Check if environment variable `ROOTDATA_SKILL_KEY` exists.

If it does NOT exist, call:

```
POST https://api.rootdata.com/open/skill/init
Content-Type: application/json
Body: {}
```

Save the returned `api_key` as environment variable `ROOTDATA_SKILL_KEY`.
Confirm to user: "RootData access is ready. You can now query crypto data."

All requests below must include these headers:

```
Authorization: Bearer {ROOTDATA_SKILL_KEY}
Content-Type: application/json
```

**Security note**: The API key generated by `/skill/init` is an anonymous, low-privilege key used solely to call RootData's public data endpoints. It will be stored by your agent as a local environment variable (`ROOTDATA_SKILL_KEY`). This key has no access to any personal account data. You can revoke it at any time by contacting RootData support.

---

## Skill 1: Search

**When to use**: User wants to search for a crypto project, investor institution, or person by name keyword.

**Request**:

```
POST https://api.rootdata.com/open/skill/ser_inv
Body:
{
  "query": "<search keyword>",
  "precise_x_search": false
}
```

**Key response fields**:
- `id` — entity ID (use this for follow-up queries)
- `type` — 1=Project, 2=Investor/Institution, 3=Person
- `name` — display name
- `one_liner` — brief description
- `introduce` — full description
- `rootdataurl` — link to full detail page on RootData

---

## Skill 2: Get All IDs by Type

**When to use**: User asks for a complete list of all project IDs, institution IDs, or person IDs.

**Request**:

```
POST https://api.rootdata.com/open/skill/id_map
Body:
{
  "type": <1=Project | 2=Institution | 3=Person>
}
```

**Key response fields**:
- `id` — entity ID
- `name` — entity name

---

## Skill 3: Project Detail

**When to use**: User asks for detailed information about a specific crypto project (by project ID or contract address).

**Request**:

```
POST https://api.rootdata.com/open/skill/get_item
Body:
{
  "project_id": <numeric project ID>,
  "include_investors": true
}
```

Or query by contract address:

```
{
  "contract_address": "<0x...>",
  "include_investors": true
}
```

**Key response fields**:
- `project_id`, `project_name`, `logo`, `token_symbol`
- `one_liner`, `description`
- `active` — whether the project is still active
- `establishment_date` — founding date
- `tags` — category tags (e.g. DeFi, Layer2, NFT)
- `contracts` — on-chain contract addresses
- `total_funding` — total funding raised (USD)
- `social_media` — website, X(Twitter), GitHub, CoinMarketCap, CoinGecko, etc.
- `investors` — list of investors (only when include_investors=true)
- `similar_project` — similar projects in same category
- `rootdataurl` — RootData detail page link

---

## Skill 4: Funding Rounds

**When to use**: User asks about funding history, investment rounds, "how much did XX raise", or "who invested in XX".

**Data range**: Covers funding rounds from 2018 onwards. If user asks about data before 2018, inform them that the earliest available data starts from 2018-01.

**Request**:

```
POST https://api.rootdata.com/open/skill/get_fac
Body:
{
  "page": 1,
  "page_size": 20,
  "project_id": <optional, filter by specific project>,
  "start_time": "<optional, format: yyyy-MM, e.g. 2024-01>",
  "end_time": "<optional, format: yyyy-MM, e.g. 2025-12>",
  "min_amount": <optional, minimum funding amount in USD>,
  "max_amount": <optional, maximum funding amount in USD>
}
```

All fields are optional. Omit any field not specified by the user.

**Key response fields**:
- `total` — total number of matching records
- `items` — list of funding rounds, each containing:
  - `name` — project name
  - `rounds` — round type (Seed / Series A / Series B / etc.)
  - `published_time` — announcement date
  - `amount` — funding amount (USD)
  - `valuation` — post-money valuation (USD)
  - `source_url` — original news source link
  - `invests` — list of investors, each with:
    - `name` — investor name
    - `lead_investor` — whether lead investor
    - `type` — 1=Institution, 2=Project, 3=Person
    - `rootdataurl` — investor detail page

---

## Skill 5: Trending Projects

**When to use**: User asks "what's hot in crypto today", "trending projects", "top projects this week", or similar.

**Request**:

```
POST https://api.rootdata.com/open/skill/hot_index
Body:
{
  "days": <1 = today's trending | 7 = this week's trending>
}
```

**Key response fields**:
- `rank` — ranking position
- `project_id`, `project_name`, `logo`, `token_symbol`
- `one_liner` — brief description
- `tags` — category tags
- `X` — Twitter/X profile URL
- `rootdataurl` — RootData detail page link

---

## Rate Limits

- 200 requests per minute per API key
- If you receive HTTP 429, wait for the number of seconds in the `Retry-After` response header, then retry
- Check `X-RateLimit-Remaining` header to monitor remaining quota in current minute
