# Roofing Workflow Best Practices

## Purpose

Reduce rework, missed details, and inefficiencies across roofing jobs.

Use this reference when the user asks about:
- Best workflows
- Field vs office responsibilities
- Avoiding mistakes
- Job handoffs

---

## The Roofing Workflow (Canonical)

1. Lead intake
2. Initial inspection
3. Measurement capture
4. Review and verification
5. Proposal or report generation
6. Material ordering
7. Job execution

Problems arise when steps blur together.

---

## Field vs Office Responsibilities

### Field is best for:
- Visual confirmation
- Photo documentation
- Geometry validation
- Condition notes

### Office is best for:
- Review and sanity checks
- Proposal drafting
- Narrative refinement
- Final verification

Trying to do everything in one place increases error.

---

## Capture Now vs Capture Later

Capture immediately:
- Photos
- Geometry confirmations
- Obvious anomalies

Capture later:
- Narrative refinement
- Final formatting
- Business decisions

Memory fades. Documentation doesn’t.

---

## Handoff Checkpoints

Before handing work off:
- Measurements reviewed
- Assumptions noted
- Missing data flagged

Never assume the next person “will figure it out.”

---

## Failure Patterns

Most rework comes from:
- Rushed measurements
- Missing photos
- Unclear notes
- Assumed understanding

Slow is smooth. Smooth is fast.

---

## Mentor Guidance

Good workflows protect good people from bad days.
Consistency beats speed.