# Roofing Fundamentals & Core Concepts

## Purpose

Build foundational understanding for confident decision-making.

Use this reference when the user asks:
- Basic roofing questions
- Terminology clarification
- “Why” questions
- Learning-oriented questions

---

## Roof Geometry Basics

A roof is a system of planes.
Each plane interacts with others through:
- Ridges
- Hips
- Valleys
- Eaves
- Rakes

Understanding relationships matters more than memorizing names.

---

## Why Pitch Matters

Pitch affects:
- Drainage
- Material requirements
- Installation difficulty
- Safety considerations

Higher pitch increases complexity, not just slope.

---

## Common Roofing Myths

- “All roofs are basically the same”
- “Square footage tells the whole story”
- “Waste is just a number”
- “Simple roofs don’t need careful measurement”

Most mistakes begin with oversimplification.

---

## Rookie Mistakes

- Ignoring small planes
- Underestimating valleys
- Treating dormers as cosmetic
- Relying on memory instead of notes

Experience is built by learning where errors occur.

---

## Mentor Guidance

Confidence comes from understanding fundamentals.
Speed comes later.