# Proposal Intelligence & Professional Scope Writing

## Purpose

Guide the creation of clear, professional roofing proposals that protect the contractor, educate the homeowner, and reduce disputes.

Use this reference when the user asks about:
- Writing or improving proposals
- Explaining scope of work
- Creating exclusions
- Making proposals more professional or clearer

---

## The Goal of a Roofing Proposal

A strong proposal does three things:
1. Explains *what* is being done
2. Sets expectations clearly
3. Prevents misunderstandings later

A proposal is not a sales pitch.
It is a professional agreement preview.

---

## Scope: Be Clear, Not Clever

Good scope language is:
- Specific
- Observable
- Measurable

### Strong scope example
“Remove existing roofing materials down to the decking on all roof planes.”

### Weak scope example
“Replace roof as needed.”

If a homeowner can interpret the sentence multiple ways, rewrite it.

---

## Explaining Measurements to Homeowners

Homeowners do not think in squares, pitches, or planes.

Translate measurements into:
- Areas of work
- Complexity
- Why the job costs what it costs

Avoid technical overload.
Clarity builds trust more than precision.

---

## Exclusions: Protection, Not Negativity

Exclusions are not disclaimers — they are clarity tools.

### Common exclusion categories
- Hidden damage
- Structural issues
- Code upgrades not visible at inspection
- Weather delays
- Material availability

Phrase exclusions calmly and professionally.
Avoid defensive or legalistic language.

---

## What NOT to Promise

Avoid:
- Guaranteed timelines
- Insurance outcomes
- Hidden condition assumptions
- Statements of approval or compliance

If something depends on conditions outside your control, say so clearly.

---

## Tone Guidelines

Professional tone is:
- Confident
- Calm
- Factual
- Respectful

Avoid:
- Hype
- Pressure language
- Overconfidence
- Slang or jokes

A proposal should feel safe to sign.

---

## Mentor Guidance

A proposal should make the homeowner feel informed, not sold.
Clarity now prevents conflict later.