# Measurement Reasoning & Professional Judgment

## Purpose

Provide expert-level reasoning for roof measurements.
This guide focuses on *judgment, sanity checks, and risk awareness* — not formulas or automation.

Use this reference when the user asks about:
- Whether a roof measurement looks correct
- How pitch, geometry, or complexity affect accuracy
- Waste decisions
- What to double-check before ordering materials
- Common measurement mistakes

---

## What Matters Most in Roof Measurements

Not all lines carry equal risk.

### Highest-impact elements
Prioritize accuracy on:
- **Ridges** – Drive plane separation and material layout
- **Valleys** – High waste, high error risk
- **Eaves** – Affect starter, drip edge, and material count
- **Plane count** – Complexity often matters more than square footage

Errors in these areas cause the largest downstream problems.

---

## Pitch: Why It Changes Everything

Pitch affects more than slope area.

Higher pitch increases:
- Material waste
- Cut complexity
- Labor difficulty
- Margin risk

### Professional guidance
- Low-slope roofs tolerate minor measurement error
- Steep or broken roofs do not
- When pitch varies across planes, treat the roof as *multiple roofs*, not one

If pitch feels “like an afterthought,” the measurement is probably incomplete.

---

## Waste: Judgment, Not Defaults

Waste is contextual.

### Increase waste when:
- Multiple valleys or hips exist
- Roof planes are small or irregular
- Steep pitch increases cut loss
- Materials have limited reuse (architectural shingles, specialty panels)

### Decrease waste when:
- Roof is simple and symmetrical
- Long, uninterrupted runs exist
- Material reuse is practical

**Red flag:** Using the same waste percentage on every job.

---

## Geometry Sanity Checks

Before trusting any measurement, mentally verify:

- Does plane count match visual complexity?
- Do ridges and valleys align logically?
- Do opposing planes feel proportional?
- Does square footage scale with roof footprint and pitch?

If the numbers “feel surprising,” pause and re-evaluate.

---

## Common Measurement Failure Patterns

Watch for these recurring issues:

- Over-trusting aerial imagery without geometry review
- Underestimating valley impact
- Treating dormers as decorative instead of structural
- Ignoring pitch changes mid-roof
- Rushing tagging or classification

Most costly errors come from *assumptions*, not math.

---

## Pre-Order Checklist (Use Every Time)

Before ordering materials, confirm:

- All planes are identified and tagged
- Pitch is applied correctly to each plane
- Valleys and hips are fully accounted for
- Waste reflects complexity, not habit
- Measurement matches visual expectation

If any item feels uncertain, re-check before proceeding.

---

## Mentor Guidance

Good measurements reduce stress downstream.
Great measurements reduce phone calls, rework, and disputes.

If you’re unsure:
- Slow down
- Re-check geometry
- Favor clarity over speed

Accuracy compounds. Errors do too.