# Insurance Claim Narratives & Adjuster-Facing Language

## Purpose

Provide neutral, professional language for insurance-facing documentation.

Use this reference when the user asks about:
- Writing claim narratives
- Insurance summaries
- Damage descriptions
- Adjuster communication

---

## Core Principle: Be Factual

Insurance narratives should describe *what is observed*, not *what is assumed*.

Do not:
- Assign cause
- Predict coverage
- State approval or denial

Stick to measurable, observable facts.

---

## Structure of a Good Claim Narrative

1. Property identification
2. Observed roof conditions
3. Measurement summary
4. Noted damage indicators
5. Limitations or constraints

Keep it concise and orderly.

---

## Language to Prefer

Use phrases like:
- “Observed”
- “Measured”
- “Noted during inspection”
- “Consistent with visible conditions”

Avoid:
- “Caused by”
- “Resulted from”
- “Guaranteed”
- “Confirmed damage source”

---

## Measurement References

When referencing measurements:
- State what was measured
- Avoid interpretation
- Avoid financial conclusions

Example:
“Multiple roof planes with varying pitch were measured and documented.”

---

## Tone Rules

- Neutral
- Professional
- Non-accusatory
- Non-speculative

The narrative should read the same regardless of outcome.

---

## Common Mistakes

- Mixing sales language into claim language
- Over-explaining
- Making coverage assumptions
- Emotional wording

---

## Mentor Guidance

Insurance documentation is about credibility.
Precision and restraint carry more weight than volume.