# Scenario Types & Templates

## Medical/Clinical Practice

**Use cases:** Patient interviews, breaking bad news, diagnostic discussions

**Scenario setup:**
- Patient age, chief complaint, relevant history
- Emotional state (anxious, denial, angry, vague)
- Hidden concerns to reveal if asked correctly
- Complicating factors (family dynamics, non-compliance)

**Realistic behaviors to simulate:**
- Rambling/tangential answers
- Minimizing symptoms
- Asking "Am I going to die?"
- Sudden emotional disclosures
- Non-compliance with treatment

**Curveballs to inject:**
- Domestic violence disclosure
- Suicidal ideation mention
- Angry outburst about wait times
- Request for inappropriate prescription

---

## Business/Professional Practice

**Use cases:** Salary negotiation, investor pitch, difficult stakeholder, performance review

**Scenario setup:**
- Role being played (CFO, investor, client, direct report)
- Personality mode (skeptical, aggressive, distracted, friendly)
- Stakes and context (budget cuts, funding round, contract renewal)
- Hidden agenda or constraints

**Personality modes:**
- **Skeptical** — Questions everything, needs data
- **Aggressive** — Interrupts, pushes hard, tests confidence
- **Distracted** — Checks phone, rushes, short attention span
- **Political** — Hints at things, never says directly
- **Friendly but unhelpful** — Nice tone, no commitment

**Time pressure mode:** Set a timer. Cut off when time expires.

---

## Therapy/Coaching Practice

**Use cases:** Client simulations for therapists, coaches, counselors

**Presentation types:**
- Anxious attachment patterns
- Depression with somatic focus
- Substance abuse ambivalence
- Resistant/deflecting client
- Crisis presentation (suicidal ideation, abuse disclosure)

**Realistic client behaviors:**
- Intellectualization (analyzes instead of feels)
- Deflection (changes subject when close to core issue)
- Testing boundaries
- Seeking reassurance/validation
- Regression under stress

**Breakthrough mechanics:**
- Don't flip instantly. Soften gradually when user uses effective techniques
- Track "therapeutic alliance" internally
- Reward good reflections, sitting with silence, appropriate challenges

---

## Creative/Writing Practice

**Use cases:** Dialogue testing, character development, story exploration

**Scenario types:**
- Dialogue scene between specific characters
- Character interview (user asks, character answers)
- "What would X do?" reaction testing
- Conflict exploration between two characters
- Backstory improvisation

**Consistency requirements:**
- Load character profiles before scene
- Track what's been established as canon
- Flag contradictions to previous sessions

---

## Gaming/Interactive Fiction

**Use cases:** D&D, solo RPG, worldbuilding, collaborative storytelling

**GM mode capabilities:**
- Maintain world state (locations, NPCs, quests, timeline)
- Generate encounters tied to active plot threads
- Voice distinct NPCs consistently
- Handle dice rolls and mechanics

**Player mode capabilities:**
- Play a character sheet user provides
- Make decisions consistent with character personality
- Defer to user on major plot directions

**Solo RPG support:**
- Oracle system for yes/no/and/but questions
- Plot twist generation using established elements
- Session journaling prompts

---

## Mentor/Personal Development

**Use cases:** Advice sessions, perspective shifts, tough conversations practice

**Mentor archetypes:**
- Visionary tech CEO type
- Stoic philosopher
- Direct but caring coach
- Devil's advocate challenger
- Supportive but honest friend

**Adaptation rules:**
- Learn user's specific situation over sessions
- Remember recurring themes and challenges
- Adjust advice to user's actual context, not generic platitudes
