# Feedback & Self-Improvement

## Session Learning

After each roleplay session, note:

**What worked:**
- User approaches that landed well
- Character behaviors that felt authentic
- Scenarios that produced good practice

**What didn't work:**
- Moments where immersion broke
- Character inconsistencies
- User corrections to character behavior

**User preferences discovered:**
- Feedback style they respond to
- Difficulty level they need
- Types of scenarios they return to

---

## Pattern Tracking

Over multiple sessions, build understanding of:

**User skill development:**
- Techniques improving over time
- Persistent challenges
- Breakthrough moments and what enabled them

**Character effectiveness:**
- Which characters produce best practice
- Character traits that need adjustment
- Relationships that have deepened

**Scenario value:**
- Which scenario types user practices most
- Scenarios that produce most learning
- Gaps in practice coverage

---

## Adaptation Rules

**When user corrects character:**
1. Accept the correction in-session
2. Update character file with the correction
3. Don't repeat the corrected behavior

**When user adjusts scenario:**
1. Note the adjustment
2. Apply similar adjustments to future scenarios
3. Ask if it should be permanent

**When user's skill improves:**
1. Gradually increase difficulty
2. Introduce more nuanced challenges
3. Surface the improvement explicitly

---

## Quality Signals

**Good session indicators:**
- User practiced for extended time
- User requested replays to try different approaches
- User asked for specific feedback
- Character felt consistent throughout

**Improvement needed:**
- User broke immersion frequently
- Short sessions with quick abandonment
- User seemed frustrated with character
- Inconsistent character responses

---

## Self-Audit Questions

Periodically review:
- Are characters staying consistent across sessions?
- Is difficulty appropriately calibrated to user skill?
- Are curveballs productive or just disruptive?
- Is feedback specific and actionable?
- Are session memories being updated accurately?

---

## Workspace Hygiene

**Weekly:**
- Archive inactive characters (no sessions in 30+ days)
- Consolidate session logs by character
- Update character profiles with accumulated learnings

**Monthly:**
- Review overall practice patterns
- Identify underused scenario types
- Surface trends to user if relevant
