---
name: ringg-voice-agent
description: >
  Integrate Ringg AI voice agents with OpenClaw for making, receiving, and managing phone calls
  powered by Ringg's Voice OS. Use this skill when the user wants to: (1) make outbound voice calls
  via Ringg AI agents, (2) trigger Ringg AI campaigns from OpenClaw, (3) check call status or
  retrieve call history/analytics from Ringg, (4) manage Ringg AI assistants (list, create, update),
  (5) connect OpenClaw to Ringg's voice platform for automated phone interactions like lead
  qualification, feedback collection, appointment reminders, or order confirmations, (6) set up
  Ringg AI as a voice provider for the OpenClaw agent. Triggers on mentions of "ringg", "voice call",
  "phone call via ringg", "ringg agent", "ringg campaign", "voice AI call", or any request to
  initiate/manage calls through the Ringg AI platform.
---

# Ringg Voice Agent Skill for OpenClaw

This skill connects OpenClaw to [Ringg AI](https://www.ringg.ai) — a Voice OS for enterprises
that provides low-latency (<337ms), multilingual (20+ languages) AI voice agents for phone
interactions including lead qualification, feedback collection, confirmations, and more.

## Prerequisites

- A Ringg AI account with API access
- `RINGG_API_KEY` environment variable set (obtain from Ringg AI dashboard)
- `RINGG_WORKSPACE_ID` environment variable set
- Optional: `RINGG_DEFAULT_ASSISTANT_ID` for a default voice agent
- Optional: `RINGG_DEFAULT_FROM_NUMBER` for outbound calls

## Configuration

Add to `openclaw.json` under `skills.entries`:

```json
{
  "skills": {
    "entries": {
      "ringg-voice-agent": {
        "enabled": true,
        "apiKey": "RINGG_API_KEY",
        "env": {
          "RINGG_API_KEY": "<your-ringg-api-key>",
          "RINGG_WORKSPACE_ID": "<your-workspace-id>",
          "RINGG_DEFAULT_ASSISTANT_ID": "<optional-default-assistant-id>",
          "RINGG_DEFAULT_FROM_NUMBER": "<optional-default-number>"
        }
      }
    }
  }
}
```

## Available Actions

### 1. Make an Outbound Call

Initiate a call from a Ringg AI assistant to a phone number.

```bash
# Basic outbound call
curl -X POST "https://api.ringg.ai/v1/calls/outbound" \
  -H "Authorization: Bearer $RINGG_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "assistant_id": "<assistant-id>",
    "to_number": "+919876543210",
    "from_number": "+918001234567",
    "dynamic_variables": {
      "customer_name": "Rahul",
      "order_id": "ORD-12345"
    }
  }'
```

**Parameters:**
- `assistant_id` — ID of the Ringg voice agent to use (falls back to `RINGG_DEFAULT_ASSISTANT_ID`)
- `to_number` — Destination phone number in E.164 format
- `from_number` — Caller ID number (falls back to `RINGG_DEFAULT_FROM_NUMBER`)
- `dynamic_variables` — Key-value pairs passed into the agent's conversation context

When the user says "call +91XXXXXXXXXX" or "make a call to [name/number]", use this action.
If no assistant_id is specified, use `RINGG_DEFAULT_ASSISTANT_ID`. If no from_number is specified,
use `RINGG_DEFAULT_FROM_NUMBER`.

### 2. Launch a Campaign

Trigger a batch calling campaign for multiple contacts.

```bash
curl -X POST "https://api.ringg.ai/v1/campaigns/launch" \
  -H "Authorization: Bearer $RINGG_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "campaign_id": "<campaign-id>",
    "contacts": [
      {"phone": "+919876543210", "name": "Rahul", "custom_field": "value"},
      {"phone": "+919876543211", "name": "Priya", "custom_field": "value"}
    ]
  }'
```

When the user asks to "launch a campaign", "start calling a list", or "run outbound calls for
[list/segment]", use this action.

### 3. Check Call Status

```bash
curl -X GET "https://api.ringg.ai/v1/calls/{call_id}/status" \
  -H "Authorization: Bearer $RINGG_API_KEY"
```

Returns: call status (ringing, in-progress, completed, failed), duration, transcript summary,
and disposition.

### 4. Get Call History & Analytics

```bash
# Recent call history
curl -X GET "https://api.ringg.ai/v1/calls/history?limit=20" \
  -H "Authorization: Bearer $RINGG_API_KEY"

# Analytics for a time range
curl -X GET "https://api.ringg.ai/v1/analytics?from=2026-02-01&to=2026-02-06" \
  -H "Authorization: Bearer $RINGG_API_KEY"
```

When the user asks "how did the calls go", "show me call analytics", or "what happened on
yesterday's calls", use these endpoints.

### 5. List Assistants

```bash
curl -X GET "https://api.ringg.ai/v1/assistants" \
  -H "Authorization: Bearer $RINGG_API_KEY"
```

When the user asks "which agents do I have", "list my ringg assistants", or needs to select
an assistant before making a call, use this.

### 6. Get Call Transcript

```bash
curl -X GET "https://api.ringg.ai/v1/calls/{call_id}/transcript" \
  -H "Authorization: Bearer $RINGG_API_KEY"
```

When the user asks "what was said on the call" or "get the transcript", use this.

## Webhook Integration (Inbound Events)

Ringg AI can push real-time call events to OpenClaw via webhooks. To receive call status
updates, transcripts, and dispositions:

1. Expose OpenClaw's webhook endpoint:
   ```bash
   ngrok http 18789
   ```

2. Configure the webhook URL in Ringg AI dashboard or via API:
   ```bash
   curl -X POST "https://api.ringg.ai/v1/webhooks" \
     -H "Authorization: Bearer $RINGG_API_KEY" \
     -H "Content-Type: application/json" \
     -d '{
       "url": "https://your-ngrok-url.ngrok.io/webhook/ringg",
       "events": ["call.completed", "call.failed", "call.transcript_ready"]
     }'
   ```

3. OpenClaw will receive POST payloads with call events that can trigger agent actions.

## Usage Patterns

**Natural language triggers → actions:**

| User says | Action |
|-----------|--------|
| "Call Rahul at +919876543210" | Outbound call with default assistant |
| "Use the PolicyBazaar agent to call this lead" | Outbound call with specific assistant |
| "Launch the feedback campaign" | Campaign launch |
| "How did the last 10 calls go?" | Call history |
| "Get the transcript for call XYZ" | Call transcript |
| "What agents do I have in Ringg?" | List assistants |
| "Show me today's call analytics" | Analytics |

## Error Handling

- **401 Unauthorized**: Check `RINGG_API_KEY` is valid
- **404 Not Found**: Verify assistant_id, call_id, or campaign_id exists
- **429 Rate Limited**: Back off and retry after the indicated interval
- **Phone number format**: Always use E.164 format (e.g., +919876543210 for India)

## API Reference

For full API details, see `references/api_reference.md` in this skill directory, or
visit the [Ringg AI API Docs](https://docs.ringg.ai).
