---
name: riddle
description: "Hosted browser automation API for agents. Screenshots, Playwright scripts, workflows — no local Chrome needed."
version: 1.0.0
tags:
  - browser
  - screenshots
  - playwright
  - automation
  - api
  - scraping
homepage: https://riddledc.com
metadata:
  openclaw:
    emoji: "🔍"
    install:
      - id: riddle-plugin
        kind: node
        label: "Install Riddle plugin (@riddledc/openclaw-riddledc)"
---

# Riddle — Hosted Browser for AI Agents

Riddle gives your agent a browser without running Chrome locally. One API call: navigate, click, fill forms, take screenshots, capture network traffic. All execution happens on Riddle's servers — your agent stays lean.

> **Quick Start:** Sign up at [riddledc.com/register](https://riddledc.com/register) and get 5 minutes of free browser time — no credit card needed. After that, pricing is **$0.50/hour, billed per second**. A single screenshot costs roughly **$0.004**.

## Why Use This Instead of Local Chrome

- **No Chromium binary** — saves ~1.2 GB RAM and avoids the Lambda/container size headaches
- **No dependency hell** — no `@sparticuz/chromium`, no Puppeteer version conflicts, no `ENOENT` / `spawn` failures
- **Full Playwright** — not just screenshots. Run real Playwright scripts, multi-step workflows, form fills, authenticated sessions
- **Works everywhere** — Lambda, containers, T3 Micro instances, anywhere your agent runs

## Install

**Step 1: Sign up** — Create a free account at [riddledc.com/register](https://riddledc.com/register). No credit card required. You get 5 minutes of browser time free.

**Step 2: Get your API key** — After signing up, grab your API key from the [dashboard](https://riddledc.com/dashboard).

**Step 3: Install and configure the plugin:**

```bash
# Install the plugin
openclaw plugins install @riddledc/openclaw-riddledc

# Allow the tools
openclaw config set tools.alsoAllow --json '["openclaw-riddledc"]'

# Set your API key
openclaw config set plugins.entries.openclaw-riddledc.config.apiKey "YOUR_RIDDLE_API_KEY"
```

**One gotcha:** OpenClaw requires plugins in the `plugins.allow` list. The CLI doesn't have an append flag, so check your current list and add `openclaw-riddledc`:

```bash
# See what you have
openclaw config get plugins.allow

# Add openclaw-riddledc to the array (or edit ~/.openclaw/openclaw.json directly)
jq '.plugins.allow += ["openclaw-riddledc"]' ~/.openclaw/openclaw.json > tmp && mv tmp ~/.openclaw/openclaw.json

# Restart
openclaw gateway restart
```

## Tools

After install, you have five tools:

**`riddle_screenshot`** — Screenshot a URL. Simplest use case.
```
Take a screenshot of https://example.com
```

**`riddle_screenshots`** — Batch screenshots of multiple URLs in one job.
```
Screenshot these three pages: https://example.com, https://example.com/about, https://example.com/pricing
```

**`riddle_steps`** — Run a step-by-step workflow (goto, click, fill, screenshot at each step).
```
Go to https://example.com/login, fill the email field with "test@example.com", fill the password field, click the submit button, then screenshot the result.
```

**`riddle_script`** — Run full Playwright code for complex automation.
```
Run a Playwright script that navigates to https://example.com, waits for the dashboard to load, extracts all table rows, and screenshots the page.
```

**`riddle_run`** — Low-level API pass-through for custom payloads.

All tools return screenshots saved to `~/.openclaw/workspace/riddle/screenshots/` (not inline base64) with file paths in the response. Add `include: ["har"]` to also capture full network traffic.

## Authenticated Sessions

Need to interact with a page behind login? Pass cookies, localStorage, or custom headers:

```
Screenshot https://app.example.com/dashboard with these cookies: [session=abc123]
```

The plugin supports cookies, localStorage entries, and custom HTTP headers as auth parameters.

## Trust & Security

This plugin was built with the concerns raised by the Moltbook agent community in mind — specifically the discussion around skill provenance, capability manifests, and runtime boundaries.

**What this plugin declares (capability manifest in `openclaw.plugin.json`):**
- **Network**: Only talks to `api.riddledc.com` — hardcoded allowlist enforced at runtime, not just config time
- **Filesystem**: Only writes to `~/.openclaw/workspace/riddle/`
- **Agent context**: Zero access to conversation history, other tools' outputs, or user profile
- **Secrets**: Only requires `RIDDLE_API_KEY`, which is only sent to the declared endpoint

**What this means in practice:**
- Even if the config is manipulated, your API key cannot be sent to any non-Riddle domain (hardcoded check runs on every request)
- The plugin cannot read your conversations, memory, or other plugins' data
- Screenshots are saved as file references, not inline base64 — prevents context overflow and accidental data leakage in logs

**Verify it yourself:**
- Source: [github.com/riddledc/integrations](https://github.com/riddledc/integrations)
- npm provenance: `npm audit signatures @riddledc/openclaw-riddledc`
- Checksums: `CHECKSUMS.txt` in the package
- Full threat model: `SECURITY.md` in the package

This is a **plugin** (auditable code), not a skill (prompt text). You can read every line before installing.

## Pricing

Riddle uses transparent per-execution pricing. A simple screenshot costs fractions of a cent. See [riddledc.com](https://riddledc.com) for current pricing.

## Get Help

- Docs: [riddledc.com](https://riddledc.com)
- Security issues: security@riddledc.com
- Plugin source: [github.com/riddledc/integrations](https://github.com/riddledc/integrations)

## Links

- **Website:** [riddledc.com](https://riddledc.com)
- **Docs:** [riddledc.com/docs](https://riddledc.com/docs)
- **Pricing:** [riddledc.com/pricing](https://riddledc.com/pricing)
- **Dashboard:** [riddledc.com/dashboard](https://riddledc.com/dashboard)
