#!/usr/bin/env bash
# RevenueCat REST API v2 wrapper
# Requires: RC_API_KEY environment variable

set -euo pipefail

if [[ -z "${RC_API_KEY:-}" ]]; then
  echo "Error: RC_API_KEY not set" >&2
  exit 1
fi

if [[ $# -lt 1 ]]; then
  echo "Usage: rc-api.sh <endpoint>" >&2
  echo "Example: rc-api.sh /projects" >&2
  exit 1
fi

ENDPOINT="$1"
BASE_URL="https://api.revenuecat.com/v2"

curl -s -X GET "${BASE_URL}${ENDPOINT}" \
  -H "Authorization: Bearer ${RC_API_KEY}" \
  -H "Content-Type: application/json"
