# Virtual Currency

Operations about virtual currencies.

## Endpoints

### GET /projects/{project_id}/virtual_currencies

Get a list of virtual currencies

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the project's virtual currencies. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/virtual_currencies?starting_after=GLD")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/virtual_currencies")
- **Status:** public

### POST /projects/{project_id}/virtual_currencies

Create a virtual currency

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Body:**
  - code: string (required) — The unique code for this virtual currency (e.g., "GLD")
  - name: string (required) — The display name of the virtual currency (e.g., "Gold")
  - description: string, nullable — Description of the virtual currency (e.g., "Gold currency used in the game")
  - product_grants: array, nullable — Product grants that define how products grant this virtual currency
- **Response:**
  - object: enum: virtual_currency (required) — String representing the object's type. Objects of the same type share the same value.
  - project_id: string (required) — ID of the project to which the virtual currency belongs (e.g., "proj1ab2c3d4")
  - code: string (required) — The unique code for this virtual currency (e.g., "GLD")
  - name: string (required) — The display name of the virtual currency (e.g., "Gold")
  - created_at: integer(int64) (required) — The date the virtual currency was created at in ms since epoch (e.g., 1658399423658)
  - description: string, nullable — Description of the virtual currency (e.g., "Gold currency used in the game")
  - product_grants: array, nullable — The grants that define how products grant this virtual currency
- **Status:** public

### DELETE /projects/{project_id}/virtual_currencies/{virtual_currency_code}

Delete a virtual currency

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), virtual_currency_code (path, required) — The virtual currency code
- **Response:**
  - object: enum: app, customer, entitlement, offering, package, paywall, product, virtual_currency, webhook_integration (required) — The type of the deleted object
  - id: string (required) — The ID of the deleted object
  - deleted_at: integer(int64) (required) — The date when the object was deleted in ms since epoch (e.g., 1658399423658)
- **Status:** public

### GET /projects/{project_id}/virtual_currencies/{virtual_currency_code}

Get a virtual currency

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), virtual_currency_code (path, required) — The virtual currency code
- **Response:**
  - object: enum: virtual_currency (required) — String representing the object's type. Objects of the same type share the same value.
  - project_id: string (required) — ID of the project to which the virtual currency belongs (e.g., "proj1ab2c3d4")
  - code: string (required) — The unique code for this virtual currency (e.g., "GLD")
  - name: string (required) — The display name of the virtual currency (e.g., "Gold")
  - created_at: integer(int64) (required) — The date the virtual currency was created at in ms since epoch (e.g., 1658399423658)
  - description: string, nullable — Description of the virtual currency (e.g., "Gold currency used in the game")
  - product_grants: array, nullable — The grants that define how products grant this virtual currency
- **Status:** public

### POST /projects/{project_id}/virtual_currencies/{virtual_currency_code}

Update a virtual currency

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), virtual_currency_code (path, required) — The virtual currency code
- **Body:**
  - name: string — The display name of the virtual currency (e.g., "Gold")
  - description: string, nullable — Description of the virtual currency (e.g., "Gold currency used in the game")
  - product_grants: array, nullable — Product grants that define how products grant this virtual currency
- **Response:**
  - object: enum: virtual_currency (required) — String representing the object's type. Objects of the same type share the same value.
  - project_id: string (required) — ID of the project to which the virtual currency belongs (e.g., "proj1ab2c3d4")
  - code: string (required) — The unique code for this virtual currency (e.g., "GLD")
  - name: string (required) — The display name of the virtual currency (e.g., "Gold")
  - created_at: integer(int64) (required) — The date the virtual currency was created at in ms since epoch (e.g., 1658399423658)
  - description: string, nullable — Description of the virtual currency (e.g., "Gold currency used in the game")
  - product_grants: array, nullable — The grants that define how products grant this virtual currency
- **Status:** public
