# Subscription

Operations about subscriptions.

## Endpoints

### GET /projects/{project_id}/subscriptions

Search subscriptions by store subscription identifier

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Query:** store_subscription_identifier (query, required) — Store ID associated with the subscription for the current or next period.
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the customer's subscriptions. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/subscriptions?starting_after=sub1a2b3c4d")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/subscriptions")
- **Status:** public

### GET /projects/{project_id}/subscriptions/{subscription_id}

Get a subscription

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), subscription_id (path, required) — ID of the subscription (e.g., "sub1a2b3c4d5e")
- **Response:**
  - object: enum: subscription (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The ID of the subscription (generated by RevenueCat) (e.g., "sub1ab2c3d4e5")
  - customer_id: string (required) — The ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - original_customer_id: string (required) — The ID of the original customer. Relevant for subscriptions that were transferred from one customer to another (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - product_id: string, nullable (required) — The RevenueCat ID of the product that the customer is subscribed to. Exists for all store types except for promotional. (e.g., "prod1a2b3c4d5e")
  - starts_at: integer(int64) (required) — The date when the subscription originally started in ms since epoch (e.g., 1658399423658)
  - current_period_starts_at: integer(int64) (required) — The date when the subscription billing period started in ms since epoch (e.g., 1658399423658)
  - current_period_ends_at: integer(int64), nullable (required) — The date when the subscription billing period is expected to end in ms since epoch. Can be null if the subscription is paused until an indefinite date. (e.g., 1658399423658)
  - ends_at: integer(int64), nullable (required) — The date when the latest subscription billing period is expected to end in ms since epoch. It will only be different from `current_period_ends_at` if `auto_renewal_status` is `has_already_renewed`, in which case it indicates the end of the next billing period. Can be null if the subscription is paused until an indefinite date. (e.g., 1658399423658)
  - gives_access: boolean (required) — Determines whether the customer should currently be provided access to the entitlements associated with the subscription (e.g., true)
  - pending_payment: boolean (required) — Determines whether there is a pending payment associated with the subscription (e.g., true)
  - auto_renewal_status: enum: will_renew, will_not_renew, will_change_product, will_pause, requires_price_increase_consent, has_already_renewed (required) — The auto renewal status of a subscription.<br><br>Possible values:<br>• `will_renew`: the subscription is currently set to automatically renew<br>• `will_not_renew`: the subscription is currently set to expire at the end of the period<br>• `will_change_product`: the subscription is currently set to change product at the end of the period (which might start a new subscription)<br>• `will_pause`: the subscription is currently set to pause at the end of the current period<br>• `requires_price_increase_consent`: the subscription will expire at the end of the current period unless the customer consents to the price increase<br>• `has_already_renewed`: the customer has already been charged for the upcoming renewal (so the renewal will take place even if the customer opts out of auto-renewal before the end of the period) (e.g., "will_renew")
  - status: enum: trialing, active, expired, in_grace_period, in_billing_retry, paused, unknown, incomplete (required) — The status of a subscription. Please note that additional states might be added in the future. To determine whether or not a subscription currently provides access to any associated entitlements, use the _gives_access_ field.<br><br>Possible values:<br>• `trialing`: the subscription is in a free trial period<br>• `active`: the subscription is active, in a paid period<br>• `expired`: the subscription is expired and no longer active<br>• `in_grace_period`: the subscription is past its regular expiry date and experienced a billing issue, but is currently still in an access-granting grace period<br>• `in_billing_retry`: the subscription has experienced a billing issue. Billing is being retried, access is suspended.-paused: the subscription is currently paused and should not provide access.<br>• `unknown`: the subscription is in an unknown state. Refer to the _gives_access_ field to determine whether or not to grant access.<br>• `incomplete`: the subscription is in an incomplete state, maybe due to incorrect billing details or because it's scheduled to start in the future. (e.g., "trialing")
  - total_revenue_in_usd: object (required) — Total revenue generated by a subscription in USD
  - presented_offering_id: string, nullable (required) — The ID of the offering the customer saw when purchasing the subscription (e.g., "ofrnge1a2b3c4d5")
  - entitlements: object (required)
  - environment: enum: production, sandbox (required) — The store environment
  - store: enum: amazon, app_store, mac_app_store, play_store, promotional, stripe, rc_billing (required) — Store the subscription belongs to (e.g., "amazon")
  - store_subscription_identifier: string (required) — The subscription identifier as per the store (e.g, for Apple App Store, the `transaction_id` of the latest transaction of the subscription, or for Google Play Store, the Order ID of the last renewal of the subscription) (e.g., 12345678)
  - ownership: enum: purchased, family_shared (required) — Ownership of the subscription
  - pending_changes: object, nullable — Indicates pending product changes. Present if the `auto_renewal_status` is `will_change_product`.
  - country: enum: , AF, AL, DZ, AS, AD, AO, AI, AQ, AG, ... (250 total), nullable — Billing country in ISO alpha 2 code (e.g., "US")
  - management_url: string, nullable (required) — The URL to manage the subscription (e.g., "https://apps.apple.com/account/subscriptions")
- **Status:** public

### POST /projects/{project_id}/subscriptions/{subscription_id}/actions/cancel

Cancel an active Web Billing subscription

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), subscription_id (path, required) — ID of the subscription (e.g., "sub1a2b3c4d5e")
- **Response:**
  - object: enum: subscription (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The ID of the subscription (generated by RevenueCat) (e.g., "sub1ab2c3d4e5")
  - customer_id: string (required) — The ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - original_customer_id: string (required) — The ID of the original customer. Relevant for subscriptions that were transferred from one customer to another (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - product_id: string, nullable (required) — The RevenueCat ID of the product that the customer is subscribed to. Exists for all store types except for promotional. (e.g., "prod1a2b3c4d5e")
  - starts_at: integer(int64) (required) — The date when the subscription originally started in ms since epoch (e.g., 1658399423658)
  - current_period_starts_at: integer(int64) (required) — The date when the subscription billing period started in ms since epoch (e.g., 1658399423658)
  - current_period_ends_at: integer(int64), nullable (required) — The date when the subscription billing period is expected to end in ms since epoch. Can be null if the subscription is paused until an indefinite date. (e.g., 1658399423658)
  - ends_at: integer(int64), nullable (required) — The date when the latest subscription billing period is expected to end in ms since epoch. It will only be different from `current_period_ends_at` if `auto_renewal_status` is `has_already_renewed`, in which case it indicates the end of the next billing period. Can be null if the subscription is paused until an indefinite date. (e.g., 1658399423658)
  - gives_access: boolean (required) — Determines whether the customer should currently be provided access to the entitlements associated with the subscription (e.g., true)
  - pending_payment: boolean (required) — Determines whether there is a pending payment associated with the subscription (e.g., true)
  - auto_renewal_status: enum: will_renew, will_not_renew, will_change_product, will_pause, requires_price_increase_consent, has_already_renewed (required) — The auto renewal status of a subscription.<br><br>Possible values:<br>• `will_renew`: the subscription is currently set to automatically renew<br>• `will_not_renew`: the subscription is currently set to expire at the end of the period<br>• `will_change_product`: the subscription is currently set to change product at the end of the period (which might start a new subscription)<br>• `will_pause`: the subscription is currently set to pause at the end of the current period<br>• `requires_price_increase_consent`: the subscription will expire at the end of the current period unless the customer consents to the price increase<br>• `has_already_renewed`: the customer has already been charged for the upcoming renewal (so the renewal will take place even if the customer opts out of auto-renewal before the end of the period) (e.g., "will_renew")
  - status: enum: trialing, active, expired, in_grace_period, in_billing_retry, paused, unknown, incomplete (required) — The status of a subscription. Please note that additional states might be added in the future. To determine whether or not a subscription currently provides access to any associated entitlements, use the _gives_access_ field.<br><br>Possible values:<br>• `trialing`: the subscription is in a free trial period<br>• `active`: the subscription is active, in a paid period<br>• `expired`: the subscription is expired and no longer active<br>• `in_grace_period`: the subscription is past its regular expiry date and experienced a billing issue, but is currently still in an access-granting grace period<br>• `in_billing_retry`: the subscription has experienced a billing issue. Billing is being retried, access is suspended.-paused: the subscription is currently paused and should not provide access.<br>• `unknown`: the subscription is in an unknown state. Refer to the _gives_access_ field to determine whether or not to grant access.<br>• `incomplete`: the subscription is in an incomplete state, maybe due to incorrect billing details or because it's scheduled to start in the future. (e.g., "trialing")
  - total_revenue_in_usd: object (required) — Total revenue generated by a subscription in USD
  - presented_offering_id: string, nullable (required) — The ID of the offering the customer saw when purchasing the subscription (e.g., "ofrnge1a2b3c4d5")
  - entitlements: object (required)
  - environment: enum: production, sandbox (required) — The store environment
  - store: enum: amazon, app_store, mac_app_store, play_store, promotional, stripe, rc_billing (required) — Store the subscription belongs to (e.g., "amazon")
  - store_subscription_identifier: string (required) — The subscription identifier as per the store (e.g, for Apple App Store, the `transaction_id` of the latest transaction of the subscription, or for Google Play Store, the Order ID of the last renewal of the subscription) (e.g., 12345678)
  - ownership: enum: purchased, family_shared (required) — Ownership of the subscription
  - pending_changes: object, nullable — Indicates pending product changes. Present if the `auto_renewal_status` is `will_change_product`.
  - country: enum: , AF, AL, DZ, AS, AD, AO, AI, AQ, AG, ... (250 total), nullable — Billing country in ISO alpha 2 code (e.g., "US")
  - management_url: string, nullable (required) — The URL to manage the subscription (e.g., "https://apps.apple.com/account/subscriptions")
- **Status:** public

### POST /projects/{project_id}/subscriptions/{subscription_id}/actions/refund

Refund an active Web Billing subscription

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), subscription_id (path, required) — ID of the subscription (e.g., "sub1a2b3c4d5e")
- **Response:**
  - object: enum: subscription (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The ID of the subscription (generated by RevenueCat) (e.g., "sub1ab2c3d4e5")
  - customer_id: string (required) — The ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - original_customer_id: string (required) — The ID of the original customer. Relevant for subscriptions that were transferred from one customer to another (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - product_id: string, nullable (required) — The RevenueCat ID of the product that the customer is subscribed to. Exists for all store types except for promotional. (e.g., "prod1a2b3c4d5e")
  - starts_at: integer(int64) (required) — The date when the subscription originally started in ms since epoch (e.g., 1658399423658)
  - current_period_starts_at: integer(int64) (required) — The date when the subscription billing period started in ms since epoch (e.g., 1658399423658)
  - current_period_ends_at: integer(int64), nullable (required) — The date when the subscription billing period is expected to end in ms since epoch. Can be null if the subscription is paused until an indefinite date. (e.g., 1658399423658)
  - ends_at: integer(int64), nullable (required) — The date when the latest subscription billing period is expected to end in ms since epoch. It will only be different from `current_period_ends_at` if `auto_renewal_status` is `has_already_renewed`, in which case it indicates the end of the next billing period. Can be null if the subscription is paused until an indefinite date. (e.g., 1658399423658)
  - gives_access: boolean (required) — Determines whether the customer should currently be provided access to the entitlements associated with the subscription (e.g., true)
  - pending_payment: boolean (required) — Determines whether there is a pending payment associated with the subscription (e.g., true)
  - auto_renewal_status: enum: will_renew, will_not_renew, will_change_product, will_pause, requires_price_increase_consent, has_already_renewed (required) — The auto renewal status of a subscription.<br><br>Possible values:<br>• `will_renew`: the subscription is currently set to automatically renew<br>• `will_not_renew`: the subscription is currently set to expire at the end of the period<br>• `will_change_product`: the subscription is currently set to change product at the end of the period (which might start a new subscription)<br>• `will_pause`: the subscription is currently set to pause at the end of the current period<br>• `requires_price_increase_consent`: the subscription will expire at the end of the current period unless the customer consents to the price increase<br>• `has_already_renewed`: the customer has already been charged for the upcoming renewal (so the renewal will take place even if the customer opts out of auto-renewal before the end of the period) (e.g., "will_renew")
  - status: enum: trialing, active, expired, in_grace_period, in_billing_retry, paused, unknown, incomplete (required) — The status of a subscription. Please note that additional states might be added in the future. To determine whether or not a subscription currently provides access to any associated entitlements, use the _gives_access_ field.<br><br>Possible values:<br>• `trialing`: the subscription is in a free trial period<br>• `active`: the subscription is active, in a paid period<br>• `expired`: the subscription is expired and no longer active<br>• `in_grace_period`: the subscription is past its regular expiry date and experienced a billing issue, but is currently still in an access-granting grace period<br>• `in_billing_retry`: the subscription has experienced a billing issue. Billing is being retried, access is suspended.-paused: the subscription is currently paused and should not provide access.<br>• `unknown`: the subscription is in an unknown state. Refer to the _gives_access_ field to determine whether or not to grant access.<br>• `incomplete`: the subscription is in an incomplete state, maybe due to incorrect billing details or because it's scheduled to start in the future. (e.g., "trialing")
  - total_revenue_in_usd: object (required) — Total revenue generated by a subscription in USD
  - presented_offering_id: string, nullable (required) — The ID of the offering the customer saw when purchasing the subscription (e.g., "ofrnge1a2b3c4d5")
  - entitlements: object (required)
  - environment: enum: production, sandbox (required) — The store environment
  - store: enum: amazon, app_store, mac_app_store, play_store, promotional, stripe, rc_billing (required) — Store the subscription belongs to (e.g., "amazon")
  - store_subscription_identifier: string (required) — The subscription identifier as per the store (e.g, for Apple App Store, the `transaction_id` of the latest transaction of the subscription, or for Google Play Store, the Order ID of the last renewal of the subscription) (e.g., 12345678)
  - ownership: enum: purchased, family_shared (required) — Ownership of the subscription
  - pending_changes: object, nullable — Indicates pending product changes. Present if the `auto_renewal_status` is `will_change_product`.
  - country: enum: , AF, AL, DZ, AS, AD, AO, AI, AQ, AG, ... (250 total), nullable — Billing country in ISO alpha 2 code (e.g., "US")
  - management_url: string, nullable (required) — The URL to manage the subscription (e.g., "https://apps.apple.com/account/subscriptions")
- **Status:** public

### GET /projects/{project_id}/subscriptions/{subscription_id}/authenticated_management_url

Get an authenticated Web Billing customer portal URL

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), subscription_id (path, required) — ID of the subscription (e.g., "sub1a2b3c4d5e")
- **Response:**
  - object: enum: authenticated_management_url (required) — String representing the object's type. Objects of the same type share the same value.
  - management_url: string (required) — A secure, single-use URL that provides temporary access to the customer portal for a specific customer. This URL can only be used once and expires after use. (e.g., "https://billing.revenuecat.com/app1a2b3c4/sub1ab2c3d4e5?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9")
- **Status:** public

### GET /projects/{project_id}/subscriptions/{subscription_id}/entitlements

Get a list of entitlements associated with a subscription

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), subscription_id (path, required) — ID of the subscription (e.g., "sub1a2b3c4d5e")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the project's entitlements. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/entitlements?starting_after=entlab21dac")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/entitlements")
- **Status:** public

### GET /projects/{project_id}/subscriptions/{subscription_id}/transactions

Get a Play Store or App Store subscription's transactions

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), subscription_id (path, required) — ID of the subscription (e.g., "sub1a2b3c4d5e")
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the projects. If not present / null, there is no next page (e.g., "/v2/projects/proj123/subscriptions/sub123/transactions?starting_after=GPA.0000-0000-0000-00000")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj123/subscriptions/sub123/transactions")
- **Status:** public

### POST /projects/{project_id}/subscriptions/{subscription_id}/transactions/{transaction_id}/actions/refund

Refund a Play Store subscription's transaction

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), subscription_id (path, required) — ID of the subscription (e.g., "sub1a2b3c4d5e"), transaction_id (path, required) — Identifier of the transaction in the store (e.g., "GPA.000-000-000-000")
- **Response:**
  - object: enum: subscription_transaction (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The ID of the subscription transaction in the store (e.g., "GPA.0000-0000-0000-00000")
  - purchased_at: integer(int64) (required) — The date of the transaction in ms since epoch (e.g., 1658399423658)
  - product_store_identifier: string — The store identifier of the purchased product (e.g., "com.example.product")
  - expiration_date: integer(int64), nullable — The expiration date of the transaction in ms since epoch (e.g., 1658399423658)
  - effective_expiration_date: integer(int64), nullable — The effective expiration date of the transaction in ms since epoch, including potential grace period (e.g., 1658399423658)
- **Status:** public
